/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.resources.ResourceTypes;
import org.sonar.db.permission.OrganizationPermission;
import org.sonar.server.permission.PermissionService;

@Immutable
public class PermissionServiceImpl
implements PermissionService {
    private static final List<String> ALL_PROJECT_PERMISSIONS = ImmutableList.of((Object)"admin", (Object)"codeviewer", (Object)"issueadmin", (Object)"securityhotspotadmin", (Object)"scan", (Object)"user");
    private static final List<OrganizationPermission> ALL_GLOBAL_PERMISSIONS = ImmutableList.copyOf((Object[])OrganizationPermission.values());
    private final List<OrganizationPermission> globalPermissions = ImmutableList.copyOf((Collection)ALL_GLOBAL_PERMISSIONS.stream().filter(s -> !s.equals((Object)OrganizationPermission.APPLICATION_CREATOR) || resourceTypes.isQualifierPresent("APP")).filter(s -> !s.equals((Object)OrganizationPermission.PORTFOLIO_CREATOR) || resourceTypes.isQualifierPresent("VW")).collect(Collectors.toList()));
    private final List<String> projectPermissions = ImmutableList.copyOf((Collection)ALL_PROJECT_PERMISSIONS.stream().filter(s -> !s.equals(OrganizationPermission.APPLICATION_CREATOR.getKey()) || resourceTypes.isQualifierPresent("APP")).filter(s -> !s.equals(OrganizationPermission.PORTFOLIO_CREATOR.getKey()) || resourceTypes.isQualifierPresent("VW")).collect(Collectors.toList()));

    public PermissionServiceImpl(ResourceTypes resourceTypes) {
    }

    @Override
    public List<OrganizationPermission> getAllOrganizationPermissions() {
        return this.globalPermissions;
    }

    @Override
    public List<String> getAllProjectPermissions() {
        return this.projectPermissions;
    }
}

