/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.index;

import com.google.common.collect.ImmutableList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.db.DatabaseUtils;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.server.permission.index.IndexPermissions;

public class PermissionIndexerDao {
    private static final String SQL_TEMPLATE = "SELECT   project_authorization.kind as kind,   project_authorization.project as project,   project_authorization.user_id as user_id,   project_authorization.group_id as group_id,   project_authorization.qualifier as qualifier FROM (       SELECT '" + (Object)((Object)RowKind.USER) + "' as kind,      projects.uuid AS project,       projects.qualifier AS qualifier,       user_roles.user_id  AS user_id,       NULL  AS group_id       FROM projects       INNER JOIN user_roles ON user_roles.resource_id = projects.id AND user_roles.role = 'user'       WHERE         (projects.qualifier = 'TRK'          or  projects.qualifier = 'VW'          or  projects.qualifier = 'APP')         AND projects.copy_component_uuid is NULL         {projectsCondition}       UNION       SELECT '" + (Object)((Object)RowKind.GROUP) + "' as kind,      projects.uuid AS project,       projects.qualifier AS qualifier,       NULL  AS user_id,       groups.id  AS group_id       FROM projects       INNER JOIN group_roles ON group_roles.resource_id = projects.id AND group_roles.role = 'user'       INNER JOIN groups ON groups.id = group_roles.group_id       WHERE         (projects.qualifier = 'TRK'          or  projects.qualifier = 'VW'          or  projects.qualifier = 'APP')         AND projects.copy_component_uuid is NULL         {projectsCondition}         AND group_id IS NOT NULL       UNION       SELECT '" + (Object)((Object)RowKind.ANYONE) + "' as kind,      projects.uuid AS project,       projects.qualifier AS qualifier,       NULL         AS user_id,       NULL     AS group_id       FROM projects       WHERE         (projects.qualifier = 'TRK'          or  projects.qualifier = 'VW'          or  projects.qualifier = 'APP')         AND projects.copy_component_uuid is NULL         AND projects.private = ?         {projectsCondition}       UNION       SELECT '" + (Object)((Object)RowKind.NONE) + "' as kind,      projects.uuid AS project,       projects.qualifier AS qualifier,       NULL AS user_id,       NULL  AS group_id       FROM projects       WHERE         (projects.qualifier = 'TRK'          or  projects.qualifier = 'VW'          or  projects.qualifier = 'APP')         AND projects.copy_component_uuid is NULL         AND projects.private = ?         {projectsCondition}     ) project_authorization";

    List<IndexPermissions> selectAll(DbClient dbClient, DbSession session) {
        return PermissionIndexerDao.doSelectByProjects(dbClient, session, Collections.emptyList());
    }

    List<IndexPermissions> selectByUuids(DbClient dbClient, DbSession session, Collection<String> projectOrViewUuids) {
        return DatabaseUtils.executeLargeInputs(projectOrViewUuids, subProjectOrViewUuids -> PermissionIndexerDao.doSelectByProjects(dbClient, session, subProjectOrViewUuids));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static List<IndexPermissions> doSelectByProjects(DbClient dbClient, DbSession session, List<String> projectUuids) {
        try {
            HashMap<String, IndexPermissions> dtosByProjectUuid = new HashMap<String, IndexPermissions>();
            try (PreparedStatement stmt = PermissionIndexerDao.createStatement(dbClient, session, projectUuids);){
                ImmutableList immutableList;
                block15: {
                    ResultSet rs = stmt.executeQuery();
                    try {
                        while (rs.next()) {
                            PermissionIndexerDao.processRow(rs, dtosByProjectUuid);
                        }
                        immutableList = ImmutableList.copyOf(dtosByProjectUuid.values());
                        if (rs == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return immutableList;
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Fail to select authorizations", e);
        }
    }

    private static PreparedStatement createStatement(DbClient dbClient, DbSession session, List<String> projectUuids) throws SQLException {
        String sql = projectUuids.isEmpty() ? StringUtils.replace((String)SQL_TEMPLATE, (String)"{projectsCondition}", (String)"") : StringUtils.replace((String)SQL_TEMPLATE, (String)"{projectsCondition}", (String)(" AND projects.uuid in (" + StringUtils.repeat((String)"?", (String)", ", (int)projectUuids.size()) + ")"));
        PreparedStatement stmt = dbClient.getMyBatis().newScrollingSelectStatement(session, sql);
        int index = 1;
        index = PermissionIndexerDao.populateProjectUuidPlaceholders(stmt, projectUuids, index);
        index = PermissionIndexerDao.populateProjectUuidPlaceholders(stmt, projectUuids, index);
        index = PermissionIndexerDao.setPrivateProjectPlaceHolder(stmt, index, false);
        index = PermissionIndexerDao.populateProjectUuidPlaceholders(stmt, projectUuids, index);
        index = PermissionIndexerDao.setPrivateProjectPlaceHolder(stmt, index, true);
        PermissionIndexerDao.populateProjectUuidPlaceholders(stmt, projectUuids, index);
        return stmt;
    }

    private static int populateProjectUuidPlaceholders(PreparedStatement stmt, List<String> projectUuids, int index) throws SQLException {
        int newIndex = index;
        for (String projectUuid : projectUuids) {
            stmt.setString(newIndex, projectUuid);
            ++newIndex;
        }
        return newIndex;
    }

    private static int setPrivateProjectPlaceHolder(PreparedStatement stmt, int index, boolean isPrivate) throws SQLException {
        int newIndex = index;
        stmt.setBoolean(newIndex, isPrivate);
        return ++newIndex;
    }

    private static void processRow(ResultSet rs, Map<String, IndexPermissions> dtosByProjectUuid) throws SQLException {
        RowKind rowKind = RowKind.valueOf(rs.getString(1));
        String projectUuid = rs.getString(2);
        IndexPermissions dto = dtosByProjectUuid.get(projectUuid);
        if (dto == null) {
            String qualifier = rs.getString(5);
            dto = new IndexPermissions(projectUuid, qualifier);
            dtosByProjectUuid.put(projectUuid, dto);
        }
        switch (rowKind) {
            case NONE: {
                break;
            }
            case USER: {
                dto.addUserId(rs.getInt(3));
                break;
            }
            case GROUP: {
                dto.addGroupId(rs.getInt(4));
                break;
            }
            case ANYONE: {
                dto.allowAnyone();
            }
        }
    }

    private static enum RowKind {
        USER,
        GROUP,
        ANYONE,
        NONE;

    }
}

