/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.permission.ws;

import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.Resources;
import com.google.protobuf.Message;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.sonar.api.server.ws.Change;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.Paging;
import org.sonar.core.util.stream.MoreCollectors;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.organization.OrganizationDto;
import org.sonar.db.permission.GroupPermissionDto;
import org.sonar.db.permission.PermissionQuery;
import org.sonar.db.user.GroupDto;
import org.sonar.server.permission.PermissionPrivilegeChecker;
import org.sonar.server.permission.ProjectId;
import org.sonar.server.permission.ws.PermissionWsSupport;
import org.sonar.server.permission.ws.PermissionsWsAction;
import org.sonar.server.permission.ws.WsParameters;
import org.sonar.server.user.UserSession;
import org.sonar.server.ws.WsUtils;
import org.sonarqube.ws.Permissions;

public class GroupsAction
implements PermissionsWsAction {
    private final DbClient dbClient;
    private final UserSession userSession;
    private final PermissionWsSupport wsSupport;
    private final WsParameters wsParameters;

    public GroupsAction(DbClient dbClient, UserSession userSession, PermissionWsSupport wsSupport, WsParameters wsParameters) {
        this.dbClient = dbClient;
        this.userSession = userSession;
        this.wsSupport = wsSupport;
        this.wsParameters = wsParameters;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction action = context.createAction("groups").setSince("5.2").setInternal(true).setDescription("Lists the groups with their permissions.<br>This service defaults to global permissions, but can be limited to project permissions by providing project id or project key.<br> This service defaults to all groups, but can be limited to groups with a specific permission by providing the desired permission.<br>Requires one of the following permissions:<ul><li>'Administer System'</li><li>'Administer' rights on the specified project</li></ul>").addPagingParams(20, 100).setChangelog(new Change[]{new Change("7.4", "The response list is returning all groups even those without permissions, the groups with permission are at the top of the list.")}).setResponseExample(Resources.getResource(this.getClass(), (String)"groups-example.json")).setHandler((RequestHandler)this);
        action.createSearchQuery("sonar", new String[]{"names"}).setDescription("Limit search to group names that contain the supplied string.").setMinimumLength(Integer.valueOf(3));
        WsParameters.createOrganizationParameter(action).setSince("6.2");
        this.wsParameters.createPermissionParameter(action).setRequired(false);
        WsParameters.createProjectParameters(action);
    }

    public void handle(Request request, Response response) throws Exception {
        try (DbSession dbSession = this.dbClient.openSession(false);){
            OrganizationDto org = this.wsSupport.findOrganization(dbSession, request.param("organization"));
            Optional<ProjectId> projectId = this.wsSupport.findProjectId(dbSession, request);
            PermissionPrivilegeChecker.checkProjectAdmin(this.userSession, org.getUuid(), projectId);
            PermissionQuery query = GroupsAction.buildPermissionQuery(request, org, projectId);
            List<GroupDto> groups = this.findGroups(dbSession, org, query);
            int total = this.dbClient.groupPermissionDao().countGroupsByQuery(dbSession, query);
            List<GroupPermissionDto> groupsWithPermission = this.findGroupPermissions(dbSession, org, groups, projectId);
            Paging paging = Paging.forPageIndex((int)request.mandatoryParamAsInt("p")).withPageSize(query.getPageSize()).andTotal(total);
            Permissions.WsGroupsResponse groupsResponse = GroupsAction.buildResponse(groups, groupsWithPermission, paging);
            WsUtils.writeProtobuf((Message)groupsResponse, request, response);
        }
    }

    private static PermissionQuery buildPermissionQuery(Request request, OrganizationDto org, Optional<ProjectId> project) {
        String textQuery = request.param("q");
        PermissionQuery.Builder permissionQuery = PermissionQuery.builder().setOrganizationUuid(org.getUuid()).setPermission(request.param("permission")).setPageIndex(Integer.valueOf(request.mandatoryParamAsInt("p"))).setPageSize(Integer.valueOf(request.mandatoryParamAsInt("ps"))).setSearchQuery(textQuery);
        project.ifPresent(projectId -> permissionQuery.setComponent(projectId.getUuid(), projectId.getId()));
        return permissionQuery.build();
    }

    private static Permissions.WsGroupsResponse buildResponse(List<GroupDto> groups, List<GroupPermissionDto> groupPermissions, Paging paging) {
        TreeMultimap permissionsByGroupId = TreeMultimap.create();
        groupPermissions.forEach(arg_0 -> GroupsAction.lambda$buildResponse$1((Multimap)permissionsByGroupId, arg_0));
        Permissions.WsGroupsResponse.Builder response = Permissions.WsGroupsResponse.newBuilder();
        groups.forEach(arg_0 -> GroupsAction.lambda$buildResponse$2(response, (Multimap)permissionsByGroupId, arg_0));
        response.getPagingBuilder().setPageIndex(paging.pageIndex()).setPageSize(paging.pageSize()).setTotal(paging.total());
        return response.build();
    }

    private List<GroupDto> findGroups(DbSession dbSession, OrganizationDto org, PermissionQuery dbQuery) {
        List orderedNames = this.dbClient.groupPermissionDao().selectGroupNamesByQuery(dbSession, dbQuery);
        List groups = this.dbClient.groupDao().selectByNames(dbSession, org.getUuid(), (Collection)orderedNames);
        if (orderedNames.contains("Anyone")) {
            groups.add(0, new GroupDto().setId(Integer.valueOf(0)).setName("Anyone").setOrganizationUuid(org.getUuid()));
        }
        return Ordering.explicit((List)orderedNames).onResultOf(GroupDto::getName).immutableSortedCopy((Iterable)groups);
    }

    private List<GroupPermissionDto> findGroupPermissions(DbSession dbSession, OrganizationDto org, List<GroupDto> groups, Optional<ProjectId> project) {
        if (groups.isEmpty()) {
            return Collections.emptyList();
        }
        List ids = (List)groups.stream().map(GroupDto::getId).collect(MoreCollectors.toList((int)groups.size()));
        return this.dbClient.groupPermissionDao().selectByGroupIds(dbSession, org.getUuid(), ids, project.isPresent() ? Long.valueOf(project.get().getId()) : null);
    }

    private static /* synthetic */ void lambda$buildResponse$2(Permissions.WsGroupsResponse.Builder response, Multimap permissionsByGroupId, GroupDto group) {
        Permissions.Group.Builder wsGroup = response.addGroupsBuilder().setName(group.getName());
        if (group.getId() != 0) {
            wsGroup.setId(String.valueOf(group.getId()));
        }
        Optional.ofNullable(group.getDescription()).ifPresent(arg_0 -> ((Permissions.Group.Builder)wsGroup).setDescription(arg_0));
        wsGroup.addAllPermissions((Iterable)permissionsByGroupId.get((Object)group.getId()));
    }

    private static /* synthetic */ void lambda$buildResponse$1(Multimap permissionsByGroupId, GroupPermissionDto groupPermission) {
        permissionsByGroupId.put((Object)groupPermission.getGroupId(), (Object)groupPermission.getRole());
    }
}

