/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.qualityprofile.ws;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonar.api.resources.Language;
import org.sonar.api.resources.Languages;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.db.DbClient;
import org.sonar.db.DbSession;
import org.sonar.db.qualityprofile.ActiveRuleDto;
import org.sonar.db.qualityprofile.QProfileDto;
import org.sonar.db.rule.RuleDefinitionDto;
import org.sonar.db.rule.RuleRepositoryDto;
import org.sonar.server.qualityprofile.QProfileComparison;
import org.sonar.server.qualityprofile.ws.QProfileWsAction;
import org.sonar.server.qualityprofile.ws.QProfileWsSupport;

public class CompareAction
implements QProfileWsAction {
    private static final String ATTRIBUTE_LEFT = "left";
    private static final String ATTRIBUTE_RIGHT = "right";
    private static final String ATTRIBUTE_IN_LEFT = "inLeft";
    private static final String ATTRIBUTE_IN_RIGHT = "inRight";
    private static final String ATTRIBUTE_MODIFIED = "modified";
    private static final String ATTRIBUTE_SAME = "same";
    private static final String ATTRIBUTE_KEY = "key";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_SEVERITY = "severity";
    private static final String ATTRIBUTE_PLUGIN_KEY = "pluginKey";
    private static final String ATTRIBUTE_PLUGIN_NAME = "pluginName";
    private static final String ATTRIBUTE_LANGUAGE_KEY = "languageKey";
    private static final String ATTRIBUTE_LANGUAGE_NAME = "languageName";
    private static final String ATTRIBUTE_PARAMS = "params";
    private static final String PARAM_LEFT_KEY = "leftKey";
    private static final String PARAM_RIGHT_KEY = "rightKey";
    private final DbClient dbClient;
    private final QProfileComparison comparator;
    private final Languages languages;
    private final QProfileWsSupport wsSupport;

    public CompareAction(DbClient dbClient, QProfileComparison comparator, Languages languages, QProfileWsSupport wsSupport) {
        this.dbClient = dbClient;
        this.comparator = comparator;
        this.languages = languages;
        this.wsSupport = wsSupport;
    }

    public void define(WebService.NewController context) {
        WebService.NewAction compare = context.createAction("compare").setDescription("Compare two quality profiles.").setHandler((RequestHandler)this).setInternal(true).setResponseExample(this.getClass().getResource("compare-example.json")).setSince("5.2");
        compare.createParam(PARAM_LEFT_KEY).setDescription("Profile key.").setExampleValue((Object)"AU-Tpxb--iU5OvuD2FLy").setRequired(true);
        compare.createParam(PARAM_RIGHT_KEY).setDescription("Another profile key.").setExampleValue((Object)"AU-TpxcA-iU5OvuD2FLz").setRequired(true);
    }

    public void handle(Request request, Response response) throws Exception {
        String leftKey = request.mandatoryParam(PARAM_LEFT_KEY);
        String rightKey = request.mandatoryParam(PARAM_RIGHT_KEY);
        try (DbSession dbSession = this.dbClient.openSession(false);){
            QProfileDto left = this.dbClient.qualityProfileDao().selectByUuid(dbSession, leftKey);
            Preconditions.checkArgument((left != null ? 1 : 0) != 0, (String)"Could not find left profile '%s'", (Object[])new Object[]{leftKey});
            QProfileDto right = this.dbClient.qualityProfileDao().selectByUuid(dbSession, rightKey);
            Preconditions.checkArgument((right != null ? 1 : 0) != 0, (String)"Could not find right profile '%s'", (Object[])new Object[]{rightKey});
            Preconditions.checkArgument((boolean)Objects.equals(left.getOrganizationUuid(), right.getOrganizationUuid()), (String)"Cannot compare quality profiles of different organizations. Quality profile left with key '%s' belongs to organization '%s', quality profile right with key '%s' belongs to organization '%s'.", (Object[])new Object[]{leftKey, left.getOrganizationUuid(), rightKey, right.getOrganizationUuid()});
            this.wsSupport.getOrganization(dbSession, left);
            QProfileComparison.QProfileComparisonResult result = this.comparator.compare(dbSession, left, right);
            List referencedRules = this.dbClient.ruleDao().selectDefinitionByKeys(dbSession, new ArrayList<RuleKey>(result.collectRuleKeys()));
            ImmutableMap rulesByKey = Maps.uniqueIndex((Iterable)referencedRules, RuleDefinitionDto::getKey);
            ImmutableMap repositoriesByKey = Maps.uniqueIndex((Iterable)this.dbClient.ruleRepositoryDao().selectAll(dbSession), RuleRepositoryDto::getKey);
            this.writeResult(response.newJsonWriter(), result, (Map<RuleKey, RuleDefinitionDto>)rulesByKey, (Map<String, RuleRepositoryDto>)repositoriesByKey);
        }
    }

    private void writeResult(JsonWriter json, QProfileComparison.QProfileComparisonResult result, Map<RuleKey, RuleDefinitionDto> rulesByKey, Map<String, RuleRepositoryDto> repositoriesByKey) {
        json.beginObject();
        json.name(ATTRIBUTE_LEFT).beginObject();
        CompareAction.writeProfile(json, result.left());
        json.endObject();
        json.name(ATTRIBUTE_RIGHT).beginObject();
        CompareAction.writeProfile(json, result.right());
        json.endObject();
        json.name(ATTRIBUTE_IN_LEFT);
        this.writeRules(json, result.inLeft(), rulesByKey, repositoriesByKey);
        json.name(ATTRIBUTE_IN_RIGHT);
        this.writeRules(json, result.inRight(), rulesByKey, repositoriesByKey);
        json.name(ATTRIBUTE_MODIFIED);
        this.writeDifferences(json, result.modified(), rulesByKey, repositoriesByKey);
        json.name(ATTRIBUTE_SAME);
        this.writeRules(json, result.same(), rulesByKey, repositoriesByKey);
        json.endObject().close();
    }

    private static void writeProfile(JsonWriter json, QProfileDto profile) {
        json.prop(ATTRIBUTE_KEY, profile.getKee()).prop(ATTRIBUTE_NAME, profile.getName());
    }

    private void writeRules(JsonWriter json, Map<RuleKey, ActiveRuleDto> activeRules, Map<RuleKey, RuleDefinitionDto> rulesByKey, Map<String, RuleRepositoryDto> repositoriesByKey) {
        json.beginArray();
        for (Map.Entry<RuleKey, ActiveRuleDto> activeRule : activeRules.entrySet()) {
            RuleKey key = activeRule.getKey();
            ActiveRuleDto value = activeRule.getValue();
            json.beginObject();
            RuleDefinitionDto rule = rulesByKey.get(key);
            this.writeRule(json, rule, repositoriesByKey.get(rule.getRepositoryKey()));
            json.prop(ATTRIBUTE_SEVERITY, value.getSeverityString());
            json.endObject();
        }
        json.endArray();
    }

    private void writeRule(JsonWriter json, RuleDefinitionDto rule, @Nullable RuleRepositoryDto repository) {
        String repositoryKey = rule.getRepositoryKey();
        json.prop(ATTRIBUTE_KEY, rule.getKey().toString()).prop(ATTRIBUTE_NAME, rule.getName()).prop(ATTRIBUTE_PLUGIN_KEY, repositoryKey);
        if (repository != null) {
            String languageKey = repository.getLanguage();
            Language language = this.languages.get(languageKey);
            json.prop(ATTRIBUTE_PLUGIN_NAME, repository.getName());
            json.prop(ATTRIBUTE_LANGUAGE_KEY, languageKey);
            json.prop(ATTRIBUTE_LANGUAGE_NAME, language == null ? null : language.getName());
        }
    }

    private void writeDifferences(JsonWriter json, Map<RuleKey, QProfileComparison.ActiveRuleDiff> modified, Map<RuleKey, RuleDefinitionDto> rulesByKey, Map<String, RuleRepositoryDto> repositoriesByKey) {
        json.beginArray();
        for (Map.Entry<RuleKey, QProfileComparison.ActiveRuleDiff> diffEntry : modified.entrySet()) {
            RuleKey key = diffEntry.getKey();
            QProfileComparison.ActiveRuleDiff value = diffEntry.getValue();
            json.beginObject();
            RuleDefinitionDto rule = rulesByKey.get(key);
            this.writeRule(json, rule, repositoriesByKey.get(rule.getRepositoryKey()));
            json.name(ATTRIBUTE_LEFT).beginObject();
            json.prop(ATTRIBUTE_SEVERITY, value.leftSeverity());
            json.name(ATTRIBUTE_PARAMS).beginObject();
            for (Map.Entry valueDiff : value.paramDifference().entriesDiffering().entrySet()) {
                json.prop((String)valueDiff.getKey(), (String)((MapDifference.ValueDifference)valueDiff.getValue()).leftValue());
            }
            for (Map.Entry valueDiff : value.paramDifference().entriesOnlyOnLeft().entrySet()) {
                json.prop((String)valueDiff.getKey(), (String)valueDiff.getValue());
            }
            json.endObject();
            json.endObject();
            json.name(ATTRIBUTE_RIGHT).beginObject();
            json.prop(ATTRIBUTE_SEVERITY, value.rightSeverity());
            json.name(ATTRIBUTE_PARAMS).beginObject();
            for (Map.Entry valueDiff : value.paramDifference().entriesDiffering().entrySet()) {
                json.prop((String)valueDiff.getKey(), (String)((MapDifference.ValueDifference)valueDiff.getValue()).rightValue());
            }
            for (Map.Entry valueDiff : value.paramDifference().entriesOnlyOnRight().entrySet()) {
                json.prop((String)valueDiff.getKey(), (String)valueDiff.getValue());
            }
            json.endObject();
            json.endObject();
            json.endObject();
        }
        json.endArray();
    }
}

