/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.setting.ws;

import com.google.common.base.Splitter;
import java.util.HashSet;
import java.util.Set;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.db.property.PropertyDto;

public class PropertySetExtractor {
    private static final Splitter COMMA_SPLITTER = Splitter.on((String)",");

    private PropertySetExtractor() {
    }

    public static Set<String> extractPropertySetKeys(PropertyDto propertyDto, PropertyDefinition definition) {
        HashSet<String> propertySetKeys = new HashSet<String>();
        definition.fields().forEach(field -> COMMA_SPLITTER.splitToList((CharSequence)propertyDto.getValue()).forEach(setId -> propertySetKeys.add(PropertySetExtractor.generatePropertySetKey(propertyDto.getKey(), setId, field.key()))));
        return propertySetKeys;
    }

    private static String generatePropertySetKey(String propertyBaseKey, String id, String fieldKey) {
        return propertyBaseKey + "." + id + "." + fieldKey;
    }
}

