/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.server.telemetry;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.picocontainer.Startable;
import org.sonar.api.config.Configuration;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.api.utils.text.JsonWriter;
import org.sonar.process.ProcessProperties;
import org.sonar.server.property.InternalProperties;
import org.sonar.server.telemetry.TelemetryClient;
import org.sonar.server.telemetry.TelemetryData;
import org.sonar.server.telemetry.TelemetryDataJsonWriter;
import org.sonar.server.telemetry.TelemetryDataLoader;
import org.sonar.server.util.GlobalLockManager;

@ServerSide
public class TelemetryDaemon
implements Startable {
    private static final String THREAD_NAME_PREFIX = "sq-telemetry-service-";
    private static final int SEVEN_DAYS = 604800000;
    private static final String I_PROP_LAST_PING = "telemetry.lastPing";
    private static final String I_PROP_OPT_OUT = "telemetry.optOut";
    private static final String LOCK_NAME = "TelemetryStat";
    private static final Logger LOG = Loggers.get(TelemetryDaemon.class);
    private static final String LOCK_DELAY_SEC = "sonar.telemetry.lock.delay";
    private final TelemetryDataLoader dataLoader;
    private final TelemetryClient telemetryClient;
    private final GlobalLockManager lockManager;
    private final Configuration config;
    private final InternalProperties internalProperties;
    private final System2 system2;
    private ScheduledExecutorService executorService;

    public TelemetryDaemon(TelemetryDataLoader dataLoader, TelemetryClient telemetryClient, Configuration config, InternalProperties internalProperties, GlobalLockManager lockManager, System2 system2) {
        this.dataLoader = dataLoader;
        this.telemetryClient = telemetryClient;
        this.config = config;
        this.internalProperties = internalProperties;
        this.lockManager = lockManager;
        this.system2 = system2;
    }

    public void start() {
        boolean isTelemetryActivated = (Boolean)this.config.getBoolean(ProcessProperties.Property.SONAR_TELEMETRY_ENABLE.getKey()).orElseThrow(() -> new IllegalStateException(String.format("Setting '%s' must be provided.", ProcessProperties.Property.SONAR_TELEMETRY_URL.getKey())));
        boolean hasOptOut = this.internalProperties.read(I_PROP_OPT_OUT).isPresent();
        if (!isTelemetryActivated && !hasOptOut) {
            this.optOut();
            this.internalProperties.write(I_PROP_OPT_OUT, String.valueOf(this.system2.now()));
            LOG.info("Sharing of SonarQube statistics is disabled.");
        }
        if (isTelemetryActivated && hasOptOut) {
            this.internalProperties.write(I_PROP_OPT_OUT, null);
        }
        if (!isTelemetryActivated) {
            return;
        }
        LOG.info("Sharing of SonarQube statistics is enabled.");
        this.executorService = Executors.newSingleThreadScheduledExecutor(TelemetryDaemon.newThreadFactory());
        int frequencyInSeconds = this.frequency();
        this.executorService.scheduleWithFixedDelay(this.telemetryCommand(), frequencyInSeconds, frequencyInSeconds, TimeUnit.SECONDS);
    }

    public void stop() {
        try {
            if (this.executorService == null) {
                return;
            }
            this.executorService.shutdown();
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static ThreadFactory newThreadFactory() {
        return new ThreadFactoryBuilder().setNameFormat("sq-telemetry-service-%d").setPriority(1).build();
    }

    private Runnable telemetryCommand() {
        return () -> {
            try {
                if (!this.lockManager.tryLock(LOCK_NAME, this.lockDuration())) {
                    return;
                }
                long now = this.system2.now();
                if (this.shouldUploadStatistics(now)) {
                    this.uploadStatistics();
                    this.internalProperties.write(I_PROP_LAST_PING, String.valueOf(TelemetryDaemon.startOfDay(now)));
                }
            }
            catch (Exception e) {
                LOG.debug("Error while checking SonarQube statistics: {}", (Object)e.getMessage());
            }
        };
    }

    private void optOut() {
        StringWriter json = new StringWriter();
        try (JsonWriter writer = JsonWriter.of((Writer)json);){
            writer.beginObject();
            writer.prop("id", this.dataLoader.loadServerId());
            writer.endObject();
        }
        this.telemetryClient.optOut(json.toString());
    }

    private void uploadStatistics() throws IOException {
        TelemetryData statistics = this.dataLoader.load();
        StringWriter jsonString = new StringWriter();
        try (JsonWriter json = JsonWriter.of((Writer)jsonString);){
            TelemetryDataJsonWriter.writeTelemetryData(json, statistics);
        }
        this.telemetryClient.upload(jsonString.toString());
    }

    private boolean shouldUploadStatistics(long now) {
        Optional<Long> lastPing = this.internalProperties.read(I_PROP_LAST_PING).map(Long::valueOf);
        return !lastPing.isPresent() || now - lastPing.get() >= 604800000L;
    }

    private static long startOfDay(long now) {
        return DateUtils.parseDate((String)DateUtils.formatDate((Date)new Date(now))).getTime();
    }

    private int frequency() {
        return (Integer)this.config.getInt(ProcessProperties.Property.SONAR_TELEMETRY_FREQUENCY_IN_SECONDS.getKey()).orElseThrow(() -> new IllegalStateException(String.format("Setting '%s' must be provided.", ProcessProperties.Property.SONAR_TELEMETRY_FREQUENCY_IN_SECONDS)));
    }

    private int lockDuration() {
        return this.config.getInt(LOCK_DELAY_SEC).orElse(60);
    }
}

