/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jss;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.tomcat.util.net.jss.IPasswordStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlainPasswordFile
implements IPasswordStore {
    private String mPwdPath = "";
    private Properties mPwdStore = new Properties();
    private static Logger logger = LoggerFactory.getLogger(PlainPasswordFile.class);

    @Override
    public void init(String pwdPath) throws IOException {
        logger.debug("PlainPasswordFile: Initializing PlainPasswordFile");
        this.mPwdPath = pwdPath;
        try (FileInputStream file = new FileInputStream(this.mPwdPath);
             InputStreamReader isr = new InputStreamReader(file);
             BufferedReader br = new BufferedReader(isr);){
            String line;
            int index = 1;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.isEmpty()) continue;
                String[] parts = line.split("=", 2);
                if (parts.length < 2) {
                    throw new IOException("Missing delimiter '=' in file " + this.mPwdPath + " in line " + index);
                }
                this.mPwdStore.put(parts[0].trim(), parts[1].trim());
                ++index;
            }
        }
    }

    @Override
    public String getPassword(String tag) {
        return this.getPassword(tag, 0);
    }

    @Override
    public String getPassword(String tag, int iteration) {
        return this.mPwdStore.getProperty(tag);
    }

    @Override
    public Enumeration<String> getTags() {
        return this.mPwdStore.propertyNames();
    }

    @Override
    public Object putPassword(String tag, String password) {
        return this.mPwdStore.setProperty(tag, password);
    }

    @Override
    public synchronized void commit() throws IOException, ClassCastException, NullPointerException {
        try (FileOutputStream file = new FileOutputStream(this.mPwdPath);
             OutputStreamWriter osw = new OutputStreamWriter(file);
             BufferedWriter bw = new BufferedWriter(osw);){
            Enumeration<Object> e = this.mPwdStore.keys();
            while (e.hasMoreElements()) {
                String key = ((String)e.nextElement()).trim();
                String val = ((String)this.mPwdStore.get(key)).trim();
                bw.write(key + "=" + val);
                bw.newLine();
            }
        }
    }

    public int getSize() {
        return this.mPwdStore.size();
    }
}

