/*
 * Rekor
 *
 * Rekor is a cryptographically secure, immutable transparency log for signed software releases.
 *
 * The version of the OpenAPI document: 0.0.1
 *
 * Generated by: https://openapi-generator.tech
 */

use base64::{engine::general_purpose::STANDARD as BASE64_STD_ENGINE, Engine as _};
use serde::{Deserialize, Serialize};

use crate::errors::SigstoreError;

/// Hashedrekord : Hashed Rekord object

#[derive(Clone, Debug, Eq, PartialEq, Serialize, Deserialize)]
pub struct Hashedrekord {
    #[serde(rename = "kind")]
    pub kind: String,
    #[serde(rename = "apiVersion")]
    pub api_version: String,
    #[serde(rename = "spec")]
    pub spec: Spec,
}

impl Hashedrekord {
    /// Hashed Rekord object
    pub fn new(kind: String, api_version: String, spec: Spec) -> Hashedrekord {
        Hashedrekord {
            kind,
            api_version,
            spec,
        }
    }
}

/// Stores the Signature and Data struct
#[derive(Default, Debug, Clone, Eq, PartialEq, Serialize, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct Spec {
    pub signature: Signature,
    pub data: Data,
}

// Design a SPEC struct
impl Spec {
    pub fn new(signature: Signature, data: Data) -> Spec {
        Spec { signature, data }
    }
}

/// Stores the signature format, signature of the artifact and the PublicKey struct
#[derive(Default, Debug, Clone, Eq, PartialEq, Serialize, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct Signature {
    pub content: String,
    pub public_key: PublicKey,
}

impl Signature {
    pub fn new(content: String, public_key: PublicKey) -> Signature {
        Signature {
            content,
            public_key,
        }
    }
}

/// Stores the public key used to sign the artifact
#[derive(Default, Debug, Clone, PartialEq, Eq, Serialize, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct PublicKey {
    content: String,
}

impl PublicKey {
    pub fn new(content: String) -> PublicKey {
        PublicKey { content }
    }

    pub fn decode(&self) -> Result<String, SigstoreError> {
        let decoded = BASE64_STD_ENGINE.decode(&self.content)?;
        String::from_utf8(decoded).map_err(|e| SigstoreError::from(e.utf8_error()))
    }
}

#[derive(Default, Debug, Clone, Eq, PartialEq, Serialize, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct Data {
    pub hash: Hash,
}

impl Data {
    pub fn new(hash: Hash) -> Data {
        Data { hash }
    }
}

#[derive(Default, Debug, Clone, PartialEq, Eq, Serialize, Deserialize)]
#[allow(non_camel_case_types)]
pub enum AlgorithmKind {
    #[default]
    sha256,
    sha1,
}

/// Stores the algorithm used to hash the artifact and the value of the hash
#[derive(Default, Debug, Clone, PartialEq, Eq, Serialize, Deserialize)]
#[serde(rename_all = "camelCase")]
pub struct Hash {
    pub algorithm: AlgorithmKind,
    pub value: String,
}

impl Hash {
    pub fn new(algorithm: AlgorithmKind, value: String) -> Hash {
        Hash { algorithm, value }
    }
}
