// GENERATED FILE - DO NOT EDIT.
// Generated by gen_load_texture_border_functions_table.py using data from
// load_texture_border_functions_data.json
//
// Copyright 2021 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// load_texture_border_functions_table":
//   Contains the LoadTextureBorderFunctionMap for texture_format_util.h
//

#include "image_util/loadtextureborder.h"
#include "libANGLE/renderer/load_texture_border_functions_table.h"

using namespace rx;

namespace angle
{

namespace
{

// ES3 texture border color loading functions vary based on:
//    - the GL internal format (supplied to glTex*Image*D)
//    - the target DXGI_FORMAT that the image will be loaded into (which is chosen based on the D3D
//    device's capabilities)
// This map type determines which loading function to use, based on these two parameters.
// This map only contains formats which need to reorder border color channel explictly.

LoadTextureBorderFunctionInfo DefaultLoadFunction()
{
    return LoadTextureBorderFunctionInfo(LoadToNative);
}

LoadTextureBorderFunctionInfo ALPHA8_EXT_to_R8_UNORM()
{
    return LoadTextureBorderFunctionInfo(LoadA8ToR8);
}

LoadTextureBorderFunctionInfo LUMINANCE8_ALPHA8_EXT_to_R8G8_UNORM()
{
    return LoadTextureBorderFunctionInfo(LoadLA8ToR8G8);
}

}  // namespace

LoadTextureBorderFunctionMap GetLoadTextureBorderFunctionsMap(GLenum internalFormat,
                                                              FormatID angleFormat)
{
    switch (internalFormat)
    {
        case GL_ALPHA8_EXT:
        {
            switch (angleFormat)
            {
                case FormatID::R8_UNORM:
                    return ALPHA8_EXT_to_R8_UNORM;
                default:
                    return DefaultLoadFunction;
            }
        }
        case GL_LUMINANCE8_ALPHA8_EXT:
        {
            switch (angleFormat)
            {
                case FormatID::R8G8_UNORM:
                    return LUMINANCE8_ALPHA8_EXT_to_R8G8_UNORM;
                default:
                    return DefaultLoadFunction;
            }
        }

        default:
            // Use LoadToNative for any format that doesn't reorder channels.
            return DefaultLoadFunction;
    }

}  // GetLoadTextureBorderFunctionsMap

}  // namespace angle
