import React from 'react';
import { IconName, IconSize, IconType } from '../../types/icon';
import { TooltipPlacement, PopoverContent } from '../Tooltip';
export declare type IconButtonVariant = 'primary' | 'secondary' | 'destructive';
export interface Props extends React.ButtonHTMLAttributes<HTMLButtonElement> {
    /** Name of the icon **/
    name: IconName;
    /** Icon size */
    size?: IconSize;
    /** Type od the icon - mono or default */
    iconType?: IconType;
    /** Tooltip content to display on hover */
    tooltip?: PopoverContent;
    /** Position of the tooltip */
    tooltipPlacement?: TooltipPlacement;
    /** Variant to change the color of the Icon */
    variant?: IconButtonVariant;
    /** Text avilable ony for screenscreen readers. Will use tooltip text as fallback. */
    ariaLabel?: string;
}
export declare const IconButton: React.ForwardRefExoticComponent<Props & React.RefAttributes<HTMLButtonElement>>;
