import { Node, Path, Range } from 'slate';
import { ReactEditor } from '../editor';
export default class ReactEditorQueries {
    /**
     * Find the path of Slate node.
     */
    findPath(this: ReactEditor, node: Node): Path | undefined;
    /**
     * Resolve the decorations for a node.
     */
    getDecorations(this: ReactEditor, node: Node): Range[];
    /**
     * Check if the editor is focused.
     */
    isFocused(this: ReactEditor): boolean;
    /**
     * Check if the editor is in read-only mode.
     */
    isReadOnly(this: ReactEditor): boolean;
}
//# sourceMappingURL=queries.d.ts.map