/**
 * Types.
 */
export declare type DOMComment = Comment;
export declare type DOMElement = Element;
export declare type DOMText = Text;
export declare type DOMNode = Node;
export declare type DOMPoint = [Node, number];
export declare type DOMRange = Range;
export declare type DOMSelection = Selection;
export declare type DOMStaticRange = StaticRange;
/**
 * Check if a DOM node is a comment node.
 */
export declare const isDOMComment: (value: any) => value is Comment;
/**
 * Check if a DOM node is an element node.
 */
export declare const isDOMElement: (value: any) => value is Element;
/**
 * Check if a value is a DOM node.
 */
export declare const isDOMNode: (value: any) => value is Node;
/**
 * Check if a DOM node is an element node.
 */
export declare const isDOMText: (value: any) => value is Text;
/**
 * Normalize a DOM point so that it always refers to a text node.
 */
export declare const normalizeDOMPoint: (domPoint: [Node, number]) => [Node, number];
/**
 * Get the nearest editable child at `index` in a `parent`, preferring
 * `direction`.
 */
export declare const getEditableChild: (parent: Element, index: number, direction: "forward" | "backward") => Node;
//# sourceMappingURL=dom.d.ts.map