/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.extensions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.extensions.CertificateScopeEntry;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.OIDMap;

public class CertificateScopeOfUseExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = 2143292831971567770L;
    public static final String NAME = "CertificateScopeOfUse";
    public static final int[] OID = new int[]{2, 16, 840, 1, 113730, 1, 17};
    public static final ObjectIdentifier ID = new ObjectIdentifier(OID);
    private Vector<CertificateScopeEntry> mEntries = null;

    public CertificateScopeOfUseExtension(boolean critical, Vector<CertificateScopeEntry> scopeEntries) throws IOException {
        this.extensionId = ID;
        this.critical = critical;
        this.extensionValue = null;
        this.mEntries = scopeEntries;
        this.encodeThis();
    }

    public CertificateScopeOfUseExtension(boolean critical) {
        this.extensionId = ID;
        this.critical = critical;
        this.extensionValue = null;
    }

    public CertificateScopeOfUseExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = ID;
        this.critical = critical;
        this.extensionValue = (byte[])((byte[])value).clone();
        this.decodeThis();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public Vector<CertificateScopeEntry> getCertificateScopeEntries() {
        return this.mEntries;
    }

    @Override
    public void set(String name, Object obj) throws CertificateException {
    }

    @Override
    public Object get(String name) throws CertificateException {
        return null;
    }

    @Override
    public void delete(String name) throws CertificateException {
    }

    @Override
    public void decode(InputStream in) throws IOException {
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return null;
    }

    private void decodeThis() throws IOException {
        DerValue val = new DerValue(this.extensionValue);
        if (val.tag != 48) {
            throw new IOException("Invalid encoding of CertificateWindow extension");
        }
        this.mEntries = new Vector();
        while (val.data.available() != 0) {
            this.mEntries.addElement(new CertificateScopeEntry(val.data.getDerValue()));
        }
    }

    private void encodeThis() throws IOException {
        try (DerOutputStream seq = new DerOutputStream();
             DerOutputStream tmp = new DerOutputStream();){
            if (this.mEntries == null) {
                throw new IOException("Invalid Scope Entries");
            }
            for (int i = 0; i < this.mEntries.size(); ++i) {
                CertificateScopeEntry se = this.mEntries.elementAt(i);
                se.encode(tmp);
            }
            seq.write((byte)48, tmp);
            this.extensionValue = seq.toByteArray();
        }
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer(super.toString() + "CertificateUseOfScope [\n");
        if (this.mEntries != null) {
            for (int i = 0; i < this.mEntries.size(); ++i) {
                CertificateScopeEntry se = this.mEntries.elementAt(i);
                s.append(se.toString());
            }
        }
        return s.toString() + "]\n";
    }

    static {
        try {
            OIDMap.addAttribute(CertificateScopeOfUseExtension.class.getName(), ID.toString(), NAME);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }
}

