/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;

public class PolicyConstraintsExtension
extends Extension
implements CertAttrSet {
    private static final long serialVersionUID = -3723759691127622370L;
    public static final String IDENT = "x509.info.extensions.PolicyConstraints";
    public static final String NAME = "PolicyConstraints";
    public static final String REQUIRE = "require";
    public static final String INHIBIT = "inhibit";
    private static final byte TAG_REQUIRE = 0;
    private static final byte TAG_INHIBIT = 1;
    private int require = -1;
    private int inhibit = -1;

    private void encodeThis() throws IOException {
        try (DerOutputStream seq = new DerOutputStream();){
            DerOutputStream tmp;
            DerOutputStream tagged = new DerOutputStream();
            if (this.require != -1) {
                tmp = new DerOutputStream();
                tmp.putInteger(new BigInt(this.require));
                tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), tmp);
            }
            if (this.inhibit != -1) {
                tmp = new DerOutputStream();
                tmp.putInteger(new BigInt(this.inhibit));
                tagged.writeImplicit(DerValue.createTag((byte)-128, false, (byte)1), tmp);
            }
            seq.write((byte)48, tagged);
            this.extensionValue = seq.toByteArray();
        }
    }

    public PolicyConstraintsExtension(boolean crit, int require, int inhibit) throws IOException {
        this.init(crit, require, inhibit);
    }

    public PolicyConstraintsExtension(int require, int inhibit) throws IOException {
        this.init(false, require, inhibit);
    }

    private void init(boolean crit, int require, int inhibit) throws IOException {
        this.require = require;
        this.inhibit = inhibit;
        this.extensionId = PKIXExtensions.PolicyConstraints_Id;
        this.critical = crit;
        this.encodeThis();
    }

    public PolicyConstraintsExtension(Boolean critical, Object value) throws IOException {
        this.extensionId = PKIXExtensions.PolicyConstraints_Id;
        this.critical = critical;
        if (!(value instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        int len = Array.getLength(value);
        byte[] extValue = new byte[len];
        System.arraycopy(value, 0, extValue, 0, len);
        this.extensionValue = extValue;
        DerValue val = new DerValue(extValue);
        if (val.tag != 48) {
            throw new IOException("Sequence tag missing for PolicyConstraint.");
        }
        DerInputStream in = val.data;
        while (in != null && in.available() != 0) {
            DerValue next = in.getDerValue();
            if (next.isContextSpecific((byte)0) && !next.isConstructed()) {
                if (this.require != -1) {
                    throw new IOException("Duplicate requireExplicitPolicyfound in the PolicyConstraintsExtension");
                }
                next.resetTag((byte)2);
                this.require = next.getInteger().toInt();
                continue;
            }
            if (next.isContextSpecific((byte)1) && !next.isConstructed()) {
                if (this.inhibit != -1) {
                    throw new IOException("Duplicate inhibitPolicyMappingfound in the PolicyConstraintsExtension");
                }
                next.resetTag((byte)2);
                this.inhibit = next.getInteger().toInt();
                continue;
            }
            throw new IOException("Invalid encoding of PolicyConstraint");
        }
    }

    @Override
    public String toString() {
        String s = super.toString() + "PolicyConstraints: [  Require: ";
        s = this.require == -1 ? s + "unspecified;" : s + this.require + ";";
        s = s + "\tInhibit: ";
        s = this.inhibit == -1 ? s + "unspecified" : s + this.inhibit;
        s = s + " ]\n";
        return s;
    }

    @Override
    public void decode(InputStream in) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.PolicyConstraints_Id;
            this.encodeThis();
        }
        super.encode(tmp);
        out.write(tmp.toByteArray());
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        this.clearValue();
        if (!(obj instanceof Integer)) {
            throw new IOException("Attribute value should be of type Integer.");
        }
        if (name.equalsIgnoreCase(REQUIRE)) {
            this.require = (Integer)obj;
        } else if (name.equalsIgnoreCase(INHIBIT)) {
            this.inhibit = (Integer)obj;
        } else {
            throw new IOException("Attribute name [" + name + "] not recognized by CertAttrSet:PolicyConstraints.");
        }
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(REQUIRE)) {
            return this.require;
        }
        if (name.equalsIgnoreCase(INHIBIT)) {
            return this.inhibit;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:PolicyConstraints.");
    }

    @Override
    public void delete(String name) throws IOException {
        if (name.equalsIgnoreCase(REQUIRE)) {
            this.require = -1;
        } else if (name.equalsIgnoreCase(INHIBIT)) {
            this.inhibit = -1;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:PolicyConstraints.");
        }
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(REQUIRE);
        elements.addElement(INHIBIT);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }

    public int getRequireExplicitMapping() {
        return this.require;
    }

    public int getInhibitPolicyMapping() {
        return this.inhibit;
    }
}

