/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.Serializable;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.CPSuri;
import org.mozilla.jss.netscape.security.x509.Qualifier;
import org.mozilla.jss.netscape.security.x509.UserNotice;

public class PolicyQualifierInfo
implements Serializable {
    private static final long serialVersionUID = -2930016944517192379L;
    public static final int[] OID_CPS = new int[]{1, 3, 6, 1, 5, 5, 7, 2, 1};
    public static final ObjectIdentifier QT_CPS = new ObjectIdentifier(OID_CPS);
    public static final int[] OID_UNOTICE = new int[]{1, 3, 6, 1, 5, 5, 7, 2, 2};
    public static final ObjectIdentifier QT_UNOTICE = new ObjectIdentifier(OID_UNOTICE);
    private ObjectIdentifier mId = null;
    private Qualifier mQualifier = null;

    public PolicyQualifierInfo(ObjectIdentifier id, Qualifier qualifier) {
        this.mId = id;
        this.mQualifier = qualifier;
    }

    public PolicyQualifierInfo(DerValue val) throws IOException {
        if (val.tag != 48) {
            throw new IOException("Invalid encoding for PolicyQualifierInfo.");
        }
        DerValue did = val.data.getDerValue();
        this.mId = did.getOID();
        if (val.data.available() != 0) {
            DerValue qualifier = val.data.getDerValue();
            this.mQualifier = qualifier.tag == 22 ? new CPSuri(qualifier) : new UserNotice(qualifier);
        }
    }

    public ObjectIdentifier getId() {
        return this.mId;
    }

    public Qualifier getQualifier() {
        return this.mQualifier;
    }

    public String toString() {
        Object s = "PolicyQualifierInfo: [";
        s = (String)s + this.getId() + " " + this.getQualifier();
        s = (String)s + "]\n";
        return s;
    }

    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        tmp.putOID(this.mId);
        this.mQualifier.encode(tmp);
        out.write((byte)48, tmp);
    }
}

