/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.nss;

import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.ssl.SSLAuthType;
import org.mozilla.jss.ssl.SSLCipher;
import org.mozilla.jss.ssl.SSLCipherAlgorithm;
import org.mozilla.jss.ssl.SSLCompressionMethod;
import org.mozilla.jss.ssl.SSLKEAType;
import org.mozilla.jss.ssl.SSLMACAlgorithm;
import org.mozilla.jss.ssl.SSLNamedGroup;
import org.mozilla.jss.ssl.SSLSignatureScheme;
import org.mozilla.jss.ssl.SSLVersion;

public class SSLChannelInfo {
    private SSLVersion protocolVersion;
    private SSLCipher cipherSuite;
    private int authKeyBits;
    private int keaKeyBits;
    private long creationTime;
    private long lastAccessTime;
    private long expirationTime;
    private byte[] sessionID;
    private SSLCompressionMethod compressionMethod;
    private boolean extendedMasterSecretUsed;
    private boolean earlyDataAccepted;
    private SSLKEAType keaType;
    private SSLNamedGroup keaGroup;
    private SSLCipherAlgorithm symCipher;
    private SSLMACAlgorithm macAlgorithm;
    private SSLAuthType authType;
    private SSLSignatureScheme signatureScheme;
    private boolean haveNSS334;
    private SSLNamedGroup originalKeaGroup;
    private boolean resumed;
    private boolean haveNSS345;
    private boolean peerDelegCred;

    public SSLChannelInfo(int protocolVersion, int cipherSuite, int authKeyBits, int keaKeyBits, long creationTime, long lastAccessTime, long expirationTime, byte[] sessionID, int compressionMethod, boolean extendedMasterSecretUsed, boolean earlyDataAccepted, int keaType, int keaGroup, int symCipher, int macAlgorithm, int authType, int signatureScheme, boolean haveNSS334, int originalKeaGroup, boolean resumed, boolean haveNSS345, boolean peerDelegCred) {
        try {
            this.protocolVersion = SSLVersion.valueOf(protocolVersion);
        }
        catch (IllegalArgumentException iae) {
            this.protocolVersion = null;
        }
        this.cipherSuite = SSLCipher.valueOf(cipherSuite);
        this.authKeyBits = authKeyBits;
        this.keaKeyBits = keaKeyBits;
        this.creationTime = creationTime;
        this.lastAccessTime = lastAccessTime;
        this.expirationTime = expirationTime;
        this.sessionID = sessionID;
        this.compressionMethod = SSLCompressionMethod.valueOf(compressionMethod);
        this.extendedMasterSecretUsed = extendedMasterSecretUsed;
        this.earlyDataAccepted = earlyDataAccepted;
        this.keaType = SSLKEAType.valueOf(keaType);
        this.keaGroup = SSLNamedGroup.valueOf(keaGroup);
        this.symCipher = SSLCipherAlgorithm.valueOf(symCipher);
        this.macAlgorithm = SSLMACAlgorithm.valueOf(macAlgorithm);
        this.authType = SSLAuthType.valueOf(authType);
        this.signatureScheme = SSLSignatureScheme.valueOf(signatureScheme);
        this.haveNSS334 = haveNSS334;
        if (haveNSS334) {
            this.originalKeaGroup = SSLNamedGroup.valueOf(originalKeaGroup);
            this.resumed = resumed;
        }
        this.haveNSS345 = haveNSS345;
        if (haveNSS345) {
            this.peerDelegCred = peerDelegCred;
        }
    }

    public SSLVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public SSLCipher getCipherSuite() {
        return this.cipherSuite;
    }

    public int getAuthKeyBits() {
        return this.authKeyBits;
    }

    public int getKeaKeyBits() {
        return this.keaKeyBits;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public byte[] getSessionID() {
        return this.sessionID;
    }

    public SSLCompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public boolean getExtendedMasterSecretUsed() {
        return this.extendedMasterSecretUsed;
    }

    public boolean getEarlyDataAccepted() {
        return this.earlyDataAccepted;
    }

    public SSLKEAType getKeaType() {
        return this.keaType;
    }

    public SSLNamedGroup getKeaGroup() {
        return this.keaGroup;
    }

    public SSLCipherAlgorithm getSymCipher() {
        return this.symCipher;
    }

    public SSLMACAlgorithm getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public SSLAuthType getAuthType() {
        return this.authType;
    }

    public SSLSignatureScheme getSignatureScheme() {
        return this.signatureScheme;
    }

    public SSLNamedGroup getOriginalKeaGroup() throws ObjectNotFoundException {
        if (!this.haveNSS334) {
            Object msg = "The version of NSS used to compile JSS doesn't ";
            msg = (String)msg + "support this field in SSLChannelInfo. Either backport ";
            msg = (String)msg + "this feature or upgrade to at least NSS v3.34. Check ";
            msg = (String)msg + "the value of HAVE_NSS_CHANNEL_INFO_ORIGINAL_KEA_GROUP ";
            msg = (String)msg + "when building JSS.";
            throw new ObjectNotFoundException((String)msg);
        }
        return this.originalKeaGroup;
    }

    public boolean getResumed() throws ObjectNotFoundException {
        if (!this.haveNSS334) {
            Object msg = "The version of NSS used to compile JSS doesn't ";
            msg = (String)msg + "support this field in SSLChannelInfo. Either backport ";
            msg = (String)msg + "this feature or upgrade to at least NSS v3.34. Check ";
            msg = (String)msg + "the value of HAVE_NSS_CHANNEL_INFO_ORIGINAL_KEA_GROUP ";
            msg = (String)msg + "when building JSS.";
            throw new ObjectNotFoundException((String)msg);
        }
        return this.resumed;
    }

    public boolean getPeerDelegCred() throws ObjectNotFoundException {
        if (!this.haveNSS345) {
            Object msg = "The version of NSS used to compile JSS doesn't ";
            msg = (String)msg + "support this field in SSLChannelInfo. Either backport ";
            msg = (String)msg + "this feature or upgrade to at least NSS v3.45. Check ";
            msg = (String)msg + "the value of HAVE_NSS_CHANNEL_INFO_PEER_DELEG_CRED ";
            msg = (String)msg + "when building JSS.";
            throw new ObjectNotFoundException((String)msg);
        }
        return this.peerDelegCred;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("SSLChannelInfo:");
        result.append("\n- protocolVersion: " + this.protocolVersion);
        result.append("\n- cipherSuite: " + this.cipherSuite);
        result.append("\n- authKeyBits: " + this.authKeyBits);
        result.append("\n- keaKeyBits: " + this.keaKeyBits);
        result.append("\n- creationTime: " + this.creationTime);
        result.append("\n- lastAccessTime: " + this.lastAccessTime);
        result.append("\n- expirationTime: " + this.expirationTime);
        result.append("\n- sessionID: " + Utils.HexEncode(this.sessionID));
        result.append("\n- compressionMethod: " + this.compressionMethod);
        result.append("\n- extendedMasterSecretUsed: " + this.extendedMasterSecretUsed);
        result.append("\n- earlyDataAccepted: " + this.earlyDataAccepted);
        result.append("\n- keaType: " + this.keaType);
        result.append("\n- keaGroup: " + this.keaGroup);
        result.append("\n- symCipher: " + this.symCipher);
        result.append("\n- macAlgorithm: " + this.macAlgorithm);
        result.append("\n- authType: " + this.authType);
        result.append("\n- signatureScheme: " + this.signatureScheme);
        if (this.haveNSS334) {
            result.append("\n- originalKeaGroup: " + this.originalKeaGroup);
            result.append("\n- resumed: " + this.resumed);
            result.append("\n- peerDelegCred: " + this.peerDelegCred);
        }
        return result.toString();
    }
}

