/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.NULL;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class AlgorithmIdentifier
implements ASN1Value {
    private OBJECT_IDENTIFIER oid;
    private ASN1Value parameters = null;
    private SEQUENCE sequence = new SEQUENCE();
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    @Override
    public Tag getTag() {
        return TAG;
    }

    public AlgorithmIdentifier(OBJECT_IDENTIFIER oid) {
        this.oid = oid;
        this.sequence.addElement(oid);
    }

    public AlgorithmIdentifier(OBJECT_IDENTIFIER oid, ASN1Value parameters) {
        this.oid = oid;
        this.sequence.addElement(oid);
        this.parameters = parameters;
        if (parameters != null) {
            this.sequence.addElement(parameters);
        } else {
            this.sequence.addElement(new NULL());
        }
    }

    public OBJECT_IDENTIFIER getOID() {
        return this.oid;
    }

    public ASN1Value getParameters() {
        return this.parameters;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicit, OutputStream ostream) throws IOException {
        this.sequence.encode(implicit, ostream);
    }

    public static class Template
    implements ASN1Template {
        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws IOException, InvalidBERException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicit, InputStream istream) throws IOException, InvalidBERException {
            SEQUENCE.Template seqt = new SEQUENCE.Template();
            seqt.addElement(new OBJECT_IDENTIFIER.Template());
            seqt.addOptionalElement(new ANY.Template());
            SEQUENCE seq = (SEQUENCE)seqt.decode(implicit, istream);
            assert (seq.size() == 2);
            OBJECT_IDENTIFIER algOID = (OBJECT_IDENTIFIER)seq.elementAt(0);
            if (seq.elementAt(1) == null) {
                return new AlgorithmIdentifier(algOID);
            }
            return new AlgorithmIdentifier((OBJECT_IDENTIFIER)seq.elementAt(0), seq.elementAt(1));
        }
    }
}

