/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.cert.X509Certificate;
import java.util.Base64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainSortingTest {
    public static Logger logger = LoggerFactory.getLogger(ChainSortingTest.class);
    public X509Certificate rootCA = new X509CertImpl(Base64.getDecoder().decode("MIIDRjCCAi6gAwIBAgIJAMHiDXjnZ1J6MA0GCSqGSIb3DQEBCwUAMDgxEDAOBgNVBAoMB0VYQU1QTEUxJDAiBgNVBAMMG1Jvb3QgQ0EgU2lnbmluZyBDZXJ0aWZpY2F0ZTAeFw0xOTAzMDUxNzQzMjFaFw0yMDAzMDQxNzQzMjFaMDgxEDAOBgNVBAoMB0VYQU1QTEUxJDAiBgNVBAMMG1Jvb3QgQ0EgU2lnbmluZyBDZXJ0aWZpY2F0ZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMDv7ovkD+JVEdlLncYDnhzbLOz2c3D37fobufnHHNwNOwfLZj8WdBCzwGJv+XGF+D2JIcKyYwYPR+HOg+xClhuuVleEgMVvgxM+HcpM4heyBD2QczNo1dfXQRBy2AXvRn8Byh+Q6zbN7VoNu8ZaMQOxZx9mEAiDZ7WxHVrEp2a4QrI6I9gKY6SyEHRzVT48JElLFokwhkMpF8vhgtj0Xxr5EEIYyCMOzvZLtpeyH8PUri3Cv/hX1RZKjWqKLSJSKirnZLhZoEEzXtsOmoeeZBeRiabidPLsxqPfWFx4+BC7t5Vw5FaIt2mPh+q6bjZipO4uWz/p4a9wpqakuzgNsYUCAwEAAaNTMFEwHQYDVR0OBBYEFCvlfY9OzAVsYpJEoqr7QfguO9v5MB8GA1UdIwQYMBaAFCvlfY9OzAVsYpJEoqr7QfguO9v5MA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAHB1lWjT6bP1jAkk6eTVwBU2pGoGoYMGV3fWQGOmWQP5T7+nHKkUjNMRACoC2hFlypwX8qQ70V5O4U+qrnxDP3EaT1zPsOB0x4DIIrpFgudL9EqnSbJ0kvSz3awwO8x/Nvx7TatCncmTw9c14eqek2puhcQWvxHzWkaDHd9WxPrZJFftbSsnZGK2A/ybDCnUA5BDeCSDb5gufTd8gbS4wS1NwYcbbrQyHnLJlFcIF4aLkbYuX1bncYp8pQv3pZ3C/ofA+yBJvPELTaHjDC40MTdjFFfMQTPZswBX2iimoGQ/ProBGg7+rLg2uk5AHff3oo/V1X0SSzo3IpvHh0jhg9I="));
    public X509Certificate subCA = new X509CertImpl(Base64.getDecoder().decode("MIIC8zCCAdsCCQCPJrl0/W/nMTANBgkqhkiG9w0BAQsFADA4MRAwDgYDVQQKDAdFWEFNUExFMSQwIgYDVQQDDBtSb290IENBIFNpZ25pbmcgQ2VydGlmaWNhdGUwHhcNMTkwMzA1MTg1MzMzWhcNMjAwMzA0MTg1MzMzWjA/MRAwDgYDVQQKDAdFWEFNUExFMSswKQYDVQQDDCJTdWJvcmRpbmF0ZSBDQSBTaWduaW5nIENlcnRpZmljYXRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzop7/TcsWElVMjzjaaAcj5KHc9H6rqhFmOsL/VYdbNzTkZD3i5DVB4sFFEHTMwEoKKpBKh9hkY8laRUWjtidDJu2+NBPLJa+k0Q+KUWIQko1rtgSjmCN+oMZFh7Mo8fV1WLSBnNjwbUrMeRKxOaR/roaYgIwH5Ra6cxsVHGngAfrjXPtiuFp7qjzUbbRBBRP2LpKDk45RzllSLhz09qgo135by2zErfUsWoma+dzvfWVI27um2DEzHMMAHELZM6BSJEYaGUW+y4cHQuuhz6Bo1YYL6RHp6RhuMzlILN7a/XznS6Zc8OV/hRlkZVUUha6tqSQ/uXNTaefa6sGrRWNdQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQAKLJq6bCZ8f/bI1OAeRNE7eIZliDnTjLqMM3sG9gkWCp1l7UD5CLAbCaL6jFEuBAvkr88LYS4A0vuMAmMVsiSsFRTZNLmazts7NZARuOYmzuNb/SZzhOBgypo6G96cqLhslzFtxXs+zJic2lQEDu+5+pcZCyETWoBTkD9sAM2dM1I9//05UTJ5mzuLFmW3rhSjsrOuYHJjwagUVVAYDrIqNgNb/XSlmWbud1t9sKHgHzN2H0DIsKaoupPhTDUABrDuG3mRn1gI2xu1RlluaXZB7ZpUZAB/hMTV8JPbHZeV08qYlfWJqhnUAZ0YQOx0yi5D98uhYB6Is/msBQ/YIbEi"));
    public X509Certificate admin = new X509CertImpl(Base64.getDecoder().decode("MIIC5DCCAcwCCQCh59LykL9CDTANBgkqhkiG9w0BAQsFADA/MRAwDgYDVQQKDAdFWEFNUExFMSswKQYDVQQDDCJTdWJvcmRpbmF0ZSBDQSBTaWduaW5nIENlcnRpZmljYXRlMB4XDTE5MDMwNTIwMDQxNloXDTIwMDMwNDIwMDQxNlowKTEQMA4GA1UECgwHRVhBTVBMRTEVMBMGCgmSJomT8ixkAQEMBWFkbWluMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA7QR+I7nLeGFntCajqIETKZ2MtpXdnrU3nkJawKwi1xQplYhFoVIqGqiX1+LfopemmR1bv2hcLt9uce4FG8jtELEF5KuCdCT99BSi8iVU+w0zs4kCfUj9HvIcFhUO0dhkyVI//ZDh16xOi5AS3jqB0PtjgYbdrmufxXQhnyoeY9CMN/w8OmN7mx2xUIApFP2LldU21rNSvly2Q0JbVDN2q7EENViYovvELW7zALGT5l/uwVUsdkdgKY2C0ZHCh+aUDvDogywIALJIRxjcCU3Udx8Vfq/+MZCNccj6CPeCxNFvL/wNtu+MpboF1jwNZB5jK9FPr3lXaH1aDdxoBSDMVwIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQApkTNJMiCOYi9MI79kHFbEESd/ae+TTvHAd7sBIe5u1v5yK5Ij2opKorY+gCVwNQOUlR7P/FIaY4eLVfPswqr3pl6O/DyqcuMLZofOHAzPEIBPFV/Qxcu1WB1SDnSW61Wx7khVnWJQPgbcPVHdgTSS4vmUOw3YAsFAqzczth6bw/5sD19WLVu6OYTSFGiofFLZXkidxZ7DIP2TUsaFJUEOkdoXlAImaHGpsCB/NXj2bWRmbzxcnMxdjxttLewQofszMM0extB95n1KFv/bzbD+m9NM+aqvLOrzOg5rlcE5cbU07DVIycYsfszFfR+9FvzA/AOpUzHg8y+ZX1rUts5f"));
    public X509Certificate agent = new X509CertImpl(Base64.getDecoder().decode("MIIC5DCCAcwCCQCh59LykL9CDjANBgkqhkiG9w0BAQsFADA/MRAwDgYDVQQKDAdFWEFNUExFMSswKQYDVQQDDCJTdWJvcmRpbmF0ZSBDQSBTaWduaW5nIENlcnRpZmljYXRlMB4XDTE5MDMwNTIwMzU1NVoXDTIwMDMwNDIwMzU1NVowKTEQMA4GA1UECgwHRVhBTVBMRTEVMBMGCgmSJomT8ixkAQEMBWFnZW50MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA7c4d93Gw4c0eW88ALqlUP01qkTzwRFLGKExbeBAwAGIY0c/c9sHFkRkEO5Fm+BeaX0qqdF5D7dk+yTJcnvbLa4YP0MC+iOBIAmRk9CZmfArMGE6dmMtt2pmQb38VlyY+3Cmjhz779rfzepAkSdmeLFTUW1I1KUIZDUovuu58Ak6j7V0Ri3V2iI8z5zLRqg1Ko517+vsr2nKeAUO+g2Zbcu8qb6uS3Qq7mrHaHg7ZZb+MyyqdqmMmLW1SQnITyqVXV/KH3mbAfsdQPopODhdH1LpuEw9xU9hVG6tn+ihytPsU7txSW2nFC3iSzL8FK1RSerWAN93hLHVf5q5XXVk87QIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQCWPtQEoUMoSJY+gqnoJNqq7DzprBQOaBMV5KKA+Fo4mSn6MUetFLPl/HD1Knub2DEEuALPq5H3O71Jfy1cscAq3sD9Zl2jPP4FvrC0ypQl/Q5bG/8QDM9p1INSAdyzPsTY+Y/mKChF3HNCzssnDWWDzHr6gSI7wnlDrE2QQGdHIn2Znx4P47RHMTFX3xumo1b8nTyjdJ2aW8T80i30SejDkmnN9XBp14D7fheGOlKeP2lCt5GDpkcFmT4YgcaVtSxMQBn7QhWV3534BqAjE5a32DEuJ6SnZph1GaDFy/kMXbjV/n9igHDsb5s4gPC9eTB38qG0y+8TDATxvJ7s2OOM"));

    @Test
    public void testNulLChain() throws Exception {
        logger.info("Testing null chain");
        X509Certificate[] input = null;
        Object[] output = Cert.sortCertificateChain(input);
        Object[] expected = null;
        Assertions.assertArrayEquals(expected, (Object[])output);
    }

    @Test
    public void testEmptyChain() throws Exception {
        logger.info("Testing empty chain");
        X509Certificate[] input = new X509Certificate[]{};
        Object[] output = Cert.sortCertificateChain((X509Certificate[])input);
        Object[] expected = new X509Certificate[]{};
        Assertions.assertArrayEquals((Object[])expected, (Object[])output);
    }

    @Test
    public void testOneLevelChain() throws Exception {
        logger.info("Testing one-level chain");
        X509Certificate[] input = new X509Certificate[]{this.rootCA};
        Object[] output = Cert.sortCertificateChain((X509Certificate[])input);
        Object[] expected = new X509Certificate[]{this.rootCA};
        Assertions.assertArrayEquals((Object[])expected, (Object[])output);
    }

    @Test
    public void testTwoLevelOrderedChain() throws Exception {
        logger.info("Testing two-level ordered chain");
        X509Certificate[] input = new X509Certificate[]{this.rootCA, this.subCA};
        Object[] output = Cert.sortCertificateChain((X509Certificate[])input);
        Object[] expected = new X509Certificate[]{this.rootCA, this.subCA};
        Assertions.assertArrayEquals((Object[])expected, (Object[])output);
    }

    @Test
    public void testTwoLevelUnorderedChain() throws Exception {
        logger.info("Testing two-level unordered chain");
        X509Certificate[] input = new X509Certificate[]{this.subCA, this.rootCA};
        Object[] output = Cert.sortCertificateChain((X509Certificate[])input);
        Object[] expected = new X509Certificate[]{this.rootCA, this.subCA};
        Assertions.assertArrayEquals((Object[])expected, (Object[])output);
    }

    @Test
    public void testThreeLevelOrderedChain() throws Exception {
        logger.info("Testing three-level ordered chain");
        X509Certificate[] input = new X509Certificate[]{this.rootCA, this.subCA, this.admin};
        Object[] output = Cert.sortCertificateChain((X509Certificate[])input);
        Object[] expected = new X509Certificate[]{this.rootCA, this.subCA, this.admin};
        Assertions.assertArrayEquals((Object[])expected, (Object[])output);
    }

    @Test
    public void testThreeLevelUnorderedChain() throws Exception {
        logger.info("Testing three-level unordered chain");
        X509Certificate[] input = new X509Certificate[]{this.admin, this.subCA, this.rootCA};
        Object[] output = Cert.sortCertificateChain((X509Certificate[])input);
        Object[] expected = new X509Certificate[]{this.rootCA, this.subCA, this.admin};
        Assertions.assertArrayEquals((Object[])expected, (Object[])output);
    }

    @Test
    public void testThreeLevelReverseChain() throws Exception {
        logger.info("Testing three-level reverse chain");
        X509Certificate[] input = new X509Certificate[]{this.subCA, this.rootCA, this.admin};
        Object[] output = Cert.sortCertificateChain((X509Certificate[])input, (boolean)true);
        Object[] expected = new X509Certificate[]{this.admin, this.subCA, this.rootCA};
        Assertions.assertArrayEquals((Object[])expected, (Object[])output);
    }

    @Test
    public void testPartialChain() throws Exception {
        logger.info("Testing partial chain");
        X509Certificate[] input = new X509Certificate[]{this.admin, this.subCA};
        Object[] output = Cert.sortCertificateChain((X509Certificate[])input);
        Object[] expected = new X509Certificate[]{this.subCA, this.admin};
        Assertions.assertArrayEquals((Object[])expected, (Object[])output);
    }

    @Test
    public void testDuplicateChain() throws Exception {
        logger.info("Testing chain with duplicate certificates");
        X509Certificate[] input = new X509Certificate[]{this.rootCA, this.subCA, this.subCA, this.admin};
        try {
            Cert.sortCertificateChain((X509Certificate[])input);
            Assertions.fail();
        }
        catch (Exception e) {
            String message = e.getMessage();
            String expected = "Duplicate certificate: " + this.subCA.getSubjectX500Principal();
            Assertions.assertEquals((Object)expected, (Object)message);
        }
    }

    @Test
    public void testBranchedChain() throws Exception {
        logger.info("Testing branched chain");
        X509Certificate[] input = new X509Certificate[]{this.rootCA, this.subCA, this.admin, this.agent};
        try {
            Cert.sortCertificateChain((X509Certificate[])input);
            Assertions.fail();
        }
        catch (Exception e) {
            String message = e.getMessage();
            String expected = "Branched chain: " + this.subCA.getSubjectX500Principal();
            Assertions.assertEquals((Object)expected, (Object)message);
        }
    }

    @Test
    public void testBrokenChain() throws Exception {
        logger.info("Testing broken chain");
        X509Certificate[] input = new X509Certificate[]{this.rootCA, this.admin};
        try {
            Cert.sortCertificateChain((X509Certificate[])input);
            Assertions.fail();
        }
        catch (Exception e) {
            String message = e.getMessage();
            String expected = "Multiple leaf certificates: [" + this.rootCA.getSubjectX500Principal() + "], [" + this.admin.getSubjectX500Principal() + "]";
            Assertions.assertEquals((Object)expected, (Object)message);
        }
    }
}

