/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.math.BigInteger;
import java.util.Enumeration;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.DatabaseCloser;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.X509Certificate;

public final class CloseDBs
extends DatabaseCloser {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.err.println("Usage: CloseDBs <dbdir>");
                System.exit(0);
            }
            CryptoManager manager = CryptoManager.getInstance();
            Enumeration tokens = manager.getAllTokens();
            while (tokens.hasMoreElements()) {
                int i;
                CryptoToken token = (CryptoToken)tokens.nextElement();
                CryptoStore store = token.getCryptoStore();
                System.out.println("Token: " + token.getName());
                X509Certificate[] certs = store.getCertificates();
                System.out.println("Certs:");
                for (i = 0; i < certs.length; ++i) {
                    System.out.println(certs[i].getNickname());
                }
                PrivateKey[] keys = store.getPrivateKeys();
                System.out.println("Keys:");
                try {
                    for (i = 0; i < keys.length; ++i) {
                        System.out.println(new BigInteger(1, keys[i].getEncoded()));
                    }
                }
                catch (Exception ex) {
                    System.out.println(ex.getMessage());
                }
            }
            System.out.println("Closing databases...");
            try {
                new CloseDBs().closeDatabases();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
                System.exit(1);
            }
            System.out.println("Databases are closed.");
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

