/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;

public class DEROutputStreamTests {
    public static void assert_f(boolean expr, String location) {
        if (!expr) {
            System.err.println("Assertion: " + location);
            assert (expr);
        }
    }

    public static void testInteger(int value, byte[] expected) throws Exception {
        DerOutputStream out = new DerOutputStream();
        BigInt num = new BigInt(value);
        out.putInteger(num);
        byte[] actual = out.toByteArray();
        DEROutputStreamTests.assert_f(actual.length == expected.length, "value=" + value);
        for (int i = 0; i < actual.length; ++i) {
            DEROutputStreamTests.assert_f(actual[i] == expected[i], "value=" + value + "|i=" + i);
        }
    }

    public static void testIntegers() throws Exception {
        int[] values = new int[]{0, 127, 128, 256};
        byte[][] expected = new byte[][]{{2, 1, 0}, {2, 1, 127}, {2, 2, 0, -128}, {2, 2, 1, 0}};
        DEROutputStreamTests.assert_f(values.length == expected.length, "testIntegers test cases");
        for (int i = 0; i < values.length; ++i) {
            DEROutputStreamTests.testInteger(values[i], expected[i]);
        }
    }

    public static void testEnumeration(int value, byte[] expected) throws Exception {
        DerOutputStream out = new DerOutputStream();
        out.putEnumerated(value);
        byte[] actual = out.toByteArray();
        DEROutputStreamTests.assert_f(actual.length == expected.length, "value=" + value);
        for (int i = 0; i < actual.length; ++i) {
            DEROutputStreamTests.assert_f(actual[i] == expected[i], "value=" + value + "|i=" + i);
        }
    }

    public static void testEnumerations() throws Exception {
        int[] values = new int[]{0, 1, 127, 128, 256, -128, -129};
        byte[][] expected = new byte[][]{{10, 1, 0}, {10, 1, 1}, {10, 1, 127}, {10, 2, 0, -128}, {10, 2, 1, 0}, {10, 1, -128}, {10, 2, -1, 127}};
        assert (values.length == expected.length);
        for (int i = 0; i < values.length; ++i) {
            DEROutputStreamTests.testEnumeration(values[i], expected[i]);
        }
    }

    public static void main(String[] args) throws Exception {
        DEROutputStreamTests.testIntegers();
        DEROutputStreamTests.testEnumerations();
    }
}

