/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.KeySpec;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.Policy;
import org.mozilla.jss.tests.FilePasswordCallback;
import org.mozilla.jss.tests.RSATestValues;
import org.mozilla.jss.tests.TestValues;
import org.mozilla.jss.util.PasswordCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyFactoryTest {
    public static Logger logger = LoggerFactory.getLogger(KeyFactoryTest.class);

    public static void main(String[] argv) throws Throwable {
        if (argv.length < 2) {
            System.out.println("Usage: java org.mozilla.jss.tests.KeyFactoryTest <dbdir> <passwordFile>");
            System.exit(1);
        }
        CryptoToken tok = CryptoManager.getInstance().getInternalKeyStorageToken();
        FilePasswordCallback cb = new FilePasswordCallback(argv[1]);
        tok.login((PasswordCallback)cb);
        new KeyFactoryTest().doTest();
    }

    public void doTest() throws Throwable {
        RSATestValues rsa = new RSATestValues();
        boolean exception = false;
        this.genPrivKeyFromSpec(rsa);
        this.genPubKeyFromSpec(rsa);
    }

    void genPrivKeyFromSpec(TestValues vals) throws Throwable {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(vals.keyGenAlg, vals.provider);
        if (vals.keyGenAlg.equalsIgnoreCase("RSA")) {
            kpg.initialize(Policy.RSA_MINIMUM_KEY_SIZE);
        } else if (vals.keyGenAlg.equalsIgnoreCase("DSA")) {
            kpg.initialize(Policy.DSA_MINIMUM_KEY_SIZE);
        } else {
            throw new IllegalArgumentException("Unknown algorithm type: " + vals.keyGenAlg);
        }
        KeyPair pair = kpg.generateKeyPair();
        KeyFactory sunFact = KeyFactory.getInstance(vals.keyGenAlg, vals.provider);
        KeySpec keySpec = sunFact.getKeySpec(pair.getPrivate(), vals.privateKeySpecClass);
        KeyFactory jssFact = KeyFactory.getInstance(vals.keyGenAlg, "Mozilla-JSS");
        PrivateKey jssPrivk = jssFact.generatePrivate(keySpec);
        this.signVerify(vals.sigAlg, jssPrivk, "Mozilla-JSS", pair.getPublic(), vals.provider);
        System.out.println("Successfully generated a " + vals.keyGenAlg + " private key from a " + vals.privateKeySpecClass.getName());
    }

    public void signVerify(String sigAlg, PrivateKey privk, String signProv, PublicKey pubk, String verifyProv) throws Throwable {
        Signature signSig = Signature.getInstance(sigAlg, signProv);
        signSig.initSign(privk);
        String toBeSigned = "blah blah blah sign me";
        signSig.update(toBeSigned.getBytes("UTF-8"));
        byte[] signature = signSig.sign();
        Signature verSig = Signature.getInstance(sigAlg, verifyProv);
        verSig.initVerify(pubk);
        verSig.update(toBeSigned.getBytes("UTF-8"));
        if (!verSig.verify(signature)) {
            throw new Exception("Private/public key mismatch: signing alg=" + sigAlg + ", signing provider=" + signProv + ", verifying provider = " + verifyProv);
        }
    }

    void genPubKeyFromSpec(TestValues vals) throws Throwable {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(vals.keyGenAlg, vals.provider);
        if (vals.keyGenAlg.equalsIgnoreCase("RSA")) {
            kpg.initialize(Policy.RSA_MINIMUM_KEY_SIZE);
        } else if (vals.keyGenAlg.equalsIgnoreCase("DSA")) {
            kpg.initialize(Policy.DSA_MINIMUM_KEY_SIZE);
        } else {
            throw new IllegalArgumentException("Unknown algorithm type: " + vals.keyGenAlg);
        }
        KeyPair pair = kpg.generateKeyPair();
        KeyFactory sunFact = KeyFactory.getInstance(vals.keyGenAlg, vals.provider);
        KeySpec keySpec = sunFact.getKeySpec(pair.getPublic(), vals.publicKeySpecClass);
        KeyFactory jssFact = KeyFactory.getInstance(vals.keyGenAlg, "Mozilla-JSS");
        PublicKey jssPubk = jssFact.generatePublic(keySpec);
        this.signVerify(vals.sigAlg, pair.getPrivate(), vals.provider, jssPubk, "Mozilla-JSS");
        System.out.println("Successfully generated a " + vals.keyGenAlg + " public key from a " + vals.publicKeySpecClass.getName());
    }
}

