/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.mozilla.jss.netscape.security.pkcs.PKCS10Attribute;
import org.mozilla.jss.netscape.security.util.DerEncoder;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS10Attributes
extends Vector<PKCS10Attribute>
implements DerEncoder {
    public static final Logger logger = LoggerFactory.getLogger(PKCS10Attributes.class);
    private static final long serialVersionUID = 1362260612357629542L;
    private Hashtable<String, PKCS10Attribute> map = new Hashtable();

    public PKCS10Attributes() {
    }

    public PKCS10Attributes(DerInputStream in) throws IOException {
        DerValue[] attrs = in.getSet(5, true);
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                PKCS10Attribute attr = new PKCS10Attribute(attrs[i]);
                this.addElement(attr);
                logger.debug("PKCS10Attributes: adding attribute: " + attr.getAttributeValue().getName());
                this.map.put(attr.getAttributeValue().getName(), attr);
            }
        }
    }

    public void encode(OutputStream out) throws IOException {
        this.derEncode(out);
    }

    @Override
    public void derEncode(OutputStream out) throws IOException {
        try (DerOutputStream attrOut = new DerOutputStream();){
            Object[] attribs = new PKCS10Attribute[this.size()];
            this.copyInto(attribs);
            attrOut.putOrderedSetOf(DerValue.createTag((byte)-128, true, (byte)0), (DerEncoder[])attribs);
            out.write(attrOut.toByteArray());
        }
    }

    public void setAttribute(String name, PKCS10Attribute attr) throws IOException {
        this.map.put(name, attr);
        this.addElement(attr);
    }

    public PKCS10Attribute getAttribute(String name) throws IOException {
        PKCS10Attribute attr = this.map.get(name);
        return attr;
    }

    public void deleteAttribute(String name) throws IOException {
        PKCS10Attribute attr = this.map.get(name);
        if (attr == null) {
            throw new IOException("No attribute found with name " + name);
        }
        this.map.remove(name);
        this.removeElement(attr);
    }

    public Enumeration<PKCS10Attribute> getElements() {
        return this.map.elements();
    }

    @Override
    public synchronized int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PKCS10Attributes other = (PKCS10Attributes)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }
}

