/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.pkcs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.mozilla.jss.netscape.security.util.BigInt;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.util.PrettyPrintFormat;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;

public class PKCS8Key
implements PrivateKey {
    private static final long serialVersionUID = -3836890099307167124L;
    protected AlgorithmId algid;
    protected byte[] key;
    protected byte[] encodedKey;
    public static final BigInteger VERSION = BigInteger.valueOf(0L);

    public static PKCS8Key parse(DerValue in) throws IOException {
        PKCS8Key subjectKey;
        if (in.tag != 48) {
            throw new IOException("corrupt private key");
        }
        BigInteger parsedVersion = in.data.getInteger().toBigInteger();
        if (!VERSION.equals(parsedVersion)) {
            throw new IOException("version mismatch: (supported: " + VERSION + ", parsed: " + parsedVersion);
        }
        AlgorithmId algorithm = AlgorithmId.parse(in.data.getDerValue());
        try {
            subjectKey = PKCS8Key.buildPKCS8Key(algorithm, in.data.getOctetString());
        }
        catch (InvalidKeyException e) {
            throw new IOException("corrupt private key");
        }
        if (in.data.available() != 0) {
            throw new IOException("excess private key");
        }
        return subjectKey;
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        this.encode();
    }

    public static PKCS8Key buildPKCS8Key(AlgorithmId algid, byte[] key) throws IOException, InvalidKeyException {
        DerOutputStream pkcs8EncodedKeyStream = new DerOutputStream();
        PKCS8Key.encode(pkcs8EncodedKeyStream, algid, key);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(pkcs8EncodedKeyStream.toByteArray());
        try {
            KeyFactory keyFac = KeyFactory.getInstance(algid.getName());
            PrivateKey privKey = keyFac.generatePrivate(pkcs8KeySpec);
            if (privKey instanceof PKCS8Key) {
                return (PKCS8Key)privKey;
            }
        }
        catch (NoSuchAlgorithmException keyFac) {
        }
        catch (InvalidKeySpecException keyFac) {
            // empty catch block
        }
        String classname = "";
        try {
            Provider sunProvider = Security.getProvider("SUN");
            if (sunProvider == null) {
                throw new InstantiationException();
            }
            classname = sunProvider.getProperty("PrivateKey.PKCS#8." + algid.getName());
            if (classname == null) {
                throw new InstantiationException();
            }
            Class<?> keyClass = Class.forName(classname);
            Object inst = keyClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (inst instanceof PKCS8Key) {
                PKCS8Key result = (PKCS8Key)inst;
                result.algid = algid;
                result.key = key;
                result.parseKeyBits();
                return result;
            }
        }
        catch (ClassNotFoundException sunProvider) {
        }
        catch (InstantiationException sunProvider) {
        }
        catch (IllegalAccessException e) {
            throw new IOException("IllegalAccessException : " + e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
        }
        catch (InvocationTargetException e) {
            throw new IOException("InvocationTargetException : " + e.getMessage(), e);
        }
        PKCS8Key result = new PKCS8Key();
        result.algid = algid;
        result.key = key;
        return result;
    }

    @Override
    public String getAlgorithm() {
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public final void encode(DerOutputStream out) throws IOException {
        PKCS8Key.encode(out, this.algid, this.key);
    }

    @Override
    public synchronized byte[] getEncoded() {
        byte[] result = null;
        try {
            result = this.encode();
        }
        catch (InvalidKeyException invalidKeyException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] encode() throws InvalidKeyException {
        if (this.encodedKey == null) {
            try {
                DerOutputStream out = new DerOutputStream();
                this.encode(out);
                this.encodedKey = out.toByteArray();
            }
            catch (IOException e) {
                throw new InvalidKeyException("IOException : " + e.getMessage());
            }
        }
        return this.copyEncodedKey(this.encodedKey);
    }

    public String toString() {
        PrettyPrintFormat pp = new PrettyPrintFormat(" ", 20);
        String keybits = pp.toHexString(this.key);
        return "algorithm = " + this.algid.toString() + ", unparsed keybits = \n" + keybits;
    }

    public void decode(InputStream in) throws InvalidKeyException {
        try {
            DerValue val = new DerValue(in);
            if (val.tag != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            BigInteger version = val.data.getInteger().toBigInteger();
            if (!version.equals(VERSION)) {
                throw new IOException("version mismatch: (supported: " + VERSION + ", parsed: " + version);
            }
            this.algid = AlgorithmId.parse(val.data.getDerValue());
            this.key = val.data.getOctetString();
            this.parseKeyBits();
            if (val.data.available() != 0) {
                throw new InvalidKeyException("excess key data");
            }
        }
        catch (IOException e) {
            throw new InvalidKeyException("IOException : " + e.getMessage());
        }
    }

    public void decode(byte[] encodedKey) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(encodedKey));
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.write(this.getEncoded());
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            this.decode(stream);
        }
        catch (InvalidKeyException e) {
            throw new IOException("deserialized key is invalid: " + e.getMessage());
        }
    }

    private byte[] copyEncodedKey(byte[] encodedKey) {
        int len = encodedKey.length;
        byte[] copy = new byte[len];
        System.arraycopy(encodedKey, 0, copy, 0, len);
        return copy;
    }

    static void encode(DerOutputStream out, AlgorithmId algid, byte[] key) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        tmp.putInteger(new BigInt(VERSION.toByteArray()));
        algid.encode(tmp);
        tmp.putOctetString(key);
        out.write((byte)48, tmp);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            byte[] b2;
            byte[] b1 = this.encodedKey != null ? this.encodedKey : this.getEncoded();
            if (b1.length != (b2 = ((Key)object).getEncoded()).length) {
                return false;
            }
            for (int i = 0; i < b1.length; ++i) {
                if (b1[i] == b2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int retval = 0;
        byte[] b1 = this.getEncoded();
        for (int i = 1; i < b1.length; ++i) {
            retval += b1[i] * i;
        }
        return retval;
    }
}

