/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.nss;

import java.util.ArrayList;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.nss.BadCertHandler;
import org.mozilla.jss.nss.CertAuthHandler;
import org.mozilla.jss.nss.PRFDProxy;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.ssl.SSLAlertEvent;
import org.mozilla.jss.util.GlobalRefProxy;

public class SSLFDProxy
extends PRFDProxy {
    public PK11Cert clientCert;
    public GlobalRefProxy globalRef = new GlobalRefProxy(this);
    public ArrayList<SSLAlertEvent> inboundAlerts;
    public int inboundOffset;
    public ArrayList<SSLAlertEvent> outboundAlerts;
    public int outboundOffset;
    public boolean needCertValidation;
    public boolean needBadCertValidation;
    public int badCertError;
    public boolean handshakeComplete;
    public CertAuthHandler certAuthHandler;
    public BadCertHandler badCertHandler;

    public SSLFDProxy(byte[] pointer) {
        super(pointer);
    }

    public void SetClientCert(X509Certificate cert) throws IllegalArgumentException {
        if (!(cert instanceof PK11Cert)) {
            throw new IllegalArgumentException("Unable to cast given certificate to PK11Cert: " + cert.getClass().getName());
        }
        this.clientCert = (PK11Cert)cert;
    }

    @Override
    protected synchronized void releaseNativeResources() throws Exception {
        super.releaseNativeResources();
        if (this.globalRef != null) {
            try {
                this.globalRef.close();
            }
            finally {
                this.globalRef = null;
            }
        }
    }

    public int invokeCertAuthHandler() {
        return this.certAuthHandler.check(this);
    }

    public int invokeBadCertHandler(int error) {
        return this.badCertHandler.check(this, error);
    }
}

