/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CHOICE;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cmc.OtherReqMsg;
import org.mozilla.jss.pkix.cmc.TaggedCertificationRequest;
import org.mozilla.jss.pkix.crmf.CertReqMsg;

public class TaggedRequest
implements ASN1Value {
    public static Type PKCS10 = Type.PKCS10;
    public static Type CRMF = Type.CRMF;
    public static Type OTHER = Type.OTHER;
    private Type type;
    private TaggedCertificationRequest tcr;
    private CertReqMsg crm;
    private OtherReqMsg orm;
    private static final Template templateInstance = new Template();

    public TaggedRequest() {
    }

    public TaggedRequest(Type type, TaggedCertificationRequest tcr, CertReqMsg crm) {
        this.type = type;
        this.tcr = tcr;
        this.crm = crm;
    }

    public TaggedRequest(Type type, TaggedCertificationRequest tcr, CertReqMsg crm, OtherReqMsg orm) {
        this.type = type;
        this.tcr = tcr;
        this.crm = crm;
        this.orm = orm;
    }

    public Type getType() {
        return this.type;
    }

    public TaggedCertificationRequest getTcr() {
        return this.tcr;
    }

    public CertReqMsg getCrm() {
        return this.crm;
    }

    public OtherReqMsg getOrm() {
        return this.orm;
    }

    @Override
    public Tag getTag() {
        if (this.type == PKCS10) {
            return Tag.get(0L);
        }
        if (this.type == CRMF) {
            return Tag.get(1L);
        }
        assert (this.type == OTHER);
        return Tag.get(2L);
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        if (this.type == PKCS10) {
            this.tcr.encode(Tag.get(0L), ostream);
        } else if (this.type == CRMF) {
            this.crm.encode(Tag.get(1L), ostream);
        } else {
            assert (this.type == OTHER);
            this.orm.encode(Tag.get(2L), ostream);
        }
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.encode(ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Type {
        static Type PKCS10 = new Type();
        static Type CRMF = new Type();
        static Type OTHER = new Type();

        private Type() {
        }
    }

    public static class Template
    implements ASN1Template {
        private CHOICE.Template choicet = new CHOICE.Template();

        public Template() {
            this.choicet.addElement(Tag.get(0L), TaggedCertificationRequest.getTemplate());
            this.choicet.addElement(Tag.get(1L), CertReqMsg.getTemplate());
            this.choicet.addElement(Tag.get(2L), OtherReqMsg.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return this.choicet.tagMatch(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            CHOICE c = (CHOICE)this.choicet.decode(istream);
            if (c.getTag().equals(Tag.get(0L))) {
                return new TaggedRequest(PKCS10, (TaggedCertificationRequest)c.getValue(), null);
            }
            if (c.getTag().equals(Tag.get(1L))) {
                return new TaggedRequest(CRMF, null, (CertReqMsg)c.getValue(), null);
            }
            assert (c.getTag().equals(Tag.get(2L)));
            return new TaggedRequest(OTHER, null, null, (OtherReqMsg)c.getValue());
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            return this.decode(istream);
        }
    }
}

