/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.crmf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class PKIPublicationInfo
implements ASN1Value {
    public static final int DONT_PUBLISH = 0;
    public static final int PLEASE_PUBLISH = 1;
    public static final int DONT_CARE = 0;
    public static final int X500 = 1;
    public static final int WEB = 2;
    public static final int LDAP = 3;
    private int action;
    private SEQUENCE pubInfos;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public int getAction() {
        return this.action;
    }

    public int numPubInfos() {
        if (this.pubInfos == null) {
            return 0;
        }
        return this.pubInfos.size();
    }

    public int getPubMethod(int index) {
        return ((INTEGER)((SEQUENCE)this.pubInfos.elementAt(index)).elementAt(0)).intValue();
    }

    public ANY getPubLocation(int index) {
        return (ANY)((SEQUENCE)this.pubInfos.elementAt(index)).elementAt(1);
    }

    public PKIPublicationInfo(int action, SEQUENCE pubInfos) {
        this.action = action;
        this.pubInfos = pubInfos;
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement(new INTEGER(this.action));
        seq.addElement(this.pubInfos);
        seq.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            SEQUENCE.Template pubInfot = new SEQUENCE.Template();
            pubInfot.addElement(INTEGER.getTemplate());
            pubInfot.addOptionalElement(ANY.getTemplate());
            this.seqt.addOptionalElement(new SEQUENCE.OF_Template(pubInfot));
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new PKIPublicationInfo(((INTEGER)seq.elementAt(0)).intValue(), (SEQUENCE)seq.elementAt(1));
        }
    }
}

