/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;

public class PBES2Params
implements ASN1Value {
    private AlgorithmIdentifier keyDerivationFunc;
    private AlgorithmIdentifier encryptionScheme;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public AlgorithmIdentifier getKeyDerivationFunc() {
        return this.keyDerivationFunc;
    }

    public AlgorithmIdentifier getEncryptionScheme() {
        return this.encryptionScheme;
    }

    public PBES2Params(AlgorithmIdentifier keyDerivationFunc, AlgorithmIdentifier encryptionScheme) {
        this.keyDerivationFunc = keyDerivationFunc;
        this.encryptionScheme = encryptionScheme;
        this.sequence = new SEQUENCE();
        this.sequence.addElement(keyDerivationFunc);
        this.sequence.addElement(encryptionScheme);
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
            this.seqt.addElement(AlgorithmIdentifier.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new PBES2Params((AlgorithmIdentifier)seq.elementAt(0), (AlgorithmIdentifier)seq.elementAt(1));
        }
    }
}

