/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.netscape.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.mozilla.jss.netscape.security.util.DerInputStream;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.DerValue;
import org.mozilla.jss.netscape.security.x509.CertAttrSet;
import org.mozilla.jss.netscape.security.x509.X500Name;

public class CertificateSubjectName
implements CertAttrSet,
Serializable {
    private static final long serialVersionUID = 503643453152834350L;
    public static final String IDENT = "x509.info.subject";
    public static final String NAME = "subject";
    public static final String DN_NAME = "dname";
    private X500Name dnName;

    public CertificateSubjectName(X500Name name) {
        this.dnName = name;
    }

    public CertificateSubjectName(DerInputStream in) throws IOException {
        this.dnName = new X500Name(in);
    }

    public CertificateSubjectName(InputStream in) throws IOException {
        DerValue derVal = new DerValue(in);
        this.dnName = new X500Name(derVal);
    }

    @Override
    public String toString() {
        if (this.dnName == null) {
            return "";
        }
        return this.dnName.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.encode(stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        this.decodeEx(stream);
    }

    @Override
    public void encode(OutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        this.dnName.encode(tmp);
        out.write(tmp.toByteArray());
    }

    public void decodeEx(InputStream in) throws IOException {
        DerValue derVal = new DerValue(in);
        this.dnName = new X500Name(derVal.toByteArray());
    }

    @Override
    public void decode(InputStream in) throws IOException {
        DerValue derVal = new DerValue(in);
        this.dnName = new X500Name(derVal);
    }

    @Override
    public void set(String name, Object obj) throws IOException {
        if (!(obj instanceof X500Name)) {
            throw new IOException("Attribute must be of type X500Name.");
        }
        if (!name.equalsIgnoreCase(DN_NAME)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
        }
        this.dnName = (X500Name)obj;
    }

    @Override
    public Object get(String name) throws IOException {
        if (name.equalsIgnoreCase(DN_NAME)) {
            return this.dnName;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
    }

    public X500Name getX500Name() {
        return this.dnName;
    }

    @Override
    public void delete(String name) throws IOException {
        if (!name.equalsIgnoreCase(DN_NAME)) {
            throw new IOException("Attribute name not recognized by CertAttrSet:CertificateSubjectName.");
        }
        this.dnName = null;
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Vector<String> elements = new Vector<String>();
        elements.addElement(DN_NAME);
        return elements.elements();
    }

    @Override
    public String getName() {
        return NAME;
    }
}

