/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.crypto.CryptoStore;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.JSSSecureRandom;
import org.mozilla.jss.crypto.KeyGenerator;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.pkcs12.AuthenticatedSafes;
import org.mozilla.jss.pkcs12.CertBag;
import org.mozilla.jss.pkcs12.PFX;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs12.SafeBag;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.pkix.primitive.EncryptedPrivateKeyInfo;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.util.ConsolePasswordCallback;
import org.mozilla.jss.util.Password;
import org.mozilla.jss.util.PasswordCallback;

public class pkcs12 {
    public static void main(String[] args) {
        try {
            PFX pfx;
            if (args.length != 3) {
                System.out.println("Usage: PFX <dbdir> <infile> <outfile>");
                System.exit(-1);
            }
            FileInputStream infile = null;
            try {
                infile = new FileInputStream(args[1]);
            }
            catch (FileNotFoundException f) {
                System.out.println("Cannot open file " + args[1] + " for reading: " + f.getMessage());
                return;
            }
            boolean certfile = false;
            CryptoManager.initialize((String)args[0]);
            CryptoManager manager = CryptoManager.getInstance();
            PFX.Template pfxt = new PFX.Template();
            try (BufferedInputStream is = new BufferedInputStream(infile, 2048);){
                pfx = (PFX)pfxt.decode((InputStream)is);
            }
            System.out.println("Decoded PFX");
            System.out.println("Version: " + pfx.getVersion());
            AuthenticatedSafes authSafes = pfx.getAuthSafes();
            SEQUENCE safeContentsSequence = authSafes.getSequence();
            System.out.println("AuthSafes has " + safeContentsSequence.size() + " SafeContents");
            System.out.println("Enter password: ");
            Password pass = Password.readPasswordFromConsole();
            System.out.println("Enter new password:");
            Password newPass = Password.readPasswordFromConsole();
            StringBuffer sb = new StringBuffer();
            if (pfx.verifyAuthSafes(pass, sb)) {
                System.out.println("AuthSafes verifies correctly.");
            } else {
                System.out.println("AuthSafes failed to verify because: " + sb);
            }
            AuthenticatedSafes newAuthSafes = new AuthenticatedSafes();
            for (int i = 0; i < safeContentsSequence.size(); ++i) {
                SEQUENCE safeContents = authSafes.getSafeContentsAt(pass, i);
                System.out.println("\n\nSafeContents #" + i + " has " + safeContents.size() + " bags");
                for (int j = 0; j < safeContents.size(); ++j) {
                    OCTET_STRING os;
                    SafeBag safeBag = (SafeBag)safeContents.elementAt(j);
                    System.out.println("\nBag " + j + " has type " + safeBag.getBagType());
                    SET attribs = safeBag.getBagAttributes();
                    if (attribs == null) {
                        System.out.println("Bag has no attributes");
                    } else {
                        for (int b = 0; b < attribs.size(); ++b) {
                            Attribute a = (Attribute)attribs.elementAt(b);
                            if (a.getType().equals((Object)SafeBag.FRIENDLY_NAME)) {
                                BMPString bs = (BMPString)((ANY)a.getValues().elementAt(0)).decodeWith((ASN1Template)BMPString.getTemplate());
                                System.out.println("Friendly Name: " + bs);
                                continue;
                            }
                            if (a.getType().equals((Object)SafeBag.LOCAL_KEY_ID)) {
                                os = (OCTET_STRING)((ANY)a.getValues().elementAt(0)).decodeWith((ASN1Template)OCTET_STRING.getTemplate());
                                System.out.println("LocalKeyID:");
                                continue;
                            }
                            System.out.println("Unknown attribute type: " + a.getType().toString());
                        }
                    }
                    ASN1Value val = safeBag.getInterpretedBagContent();
                    if (val instanceof PrivateKeyInfo) {
                        System.out.println("content is PrivateKeyInfo");
                        continue;
                    }
                    if (val instanceof EncryptedPrivateKeyInfo) {
                        EncryptedPrivateKeyInfo epki = (EncryptedPrivateKeyInfo)val;
                        System.out.println("content is EncryptedPrivateKeyInfo, algoid:" + epki.getEncryptionAlgorithm().getOID());
                        PrivateKeyInfo pki = epki.decrypt(pass, (KeyGenerator.CharToByteConverter)new PasswordConverter());
                        CryptoToken tok = manager.getTokenByName("Internal Key Storage Token");
                        CryptoStore store = tok.getCryptoStore();
                        tok.login((PasswordCallback)new ConsolePasswordCallback());
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        pki.encode((OutputStream)baos);
                        store.importPrivateKey(baos.toByteArray(), PrivateKey.RSA);
                        byte[] salt = new byte[PBEAlgorithm.PBE_SHA1_DES3_CBC.getSaltLength()];
                        JSSSecureRandom rand = CryptoManager.getInstance().getSecureRNG();
                        rand.nextBytes(salt);
                        epki = EncryptedPrivateKeyInfo.createPBE((PBEAlgorithm)PBEAlgorithm.PBE_SHA1_DES3_CBC, (Password)newPass, (byte[])salt, (int)1, (KeyGenerator.CharToByteConverter)new PasswordConverter(), (PrivateKeyInfo)pki);
                        safeContents.insertElementAt((ASN1Value)new SafeBag(safeBag.getBagType(), (ASN1Value)epki, safeBag.getBagAttributes()), i);
                        safeContents.removeElementAt(i + 1);
                        continue;
                    }
                    if (val instanceof CertBag) {
                        System.out.println("content is CertBag");
                        CertBag cb = (CertBag)val;
                        if (cb.getCertType().equals((Object)CertBag.X509_CERT_TYPE)) {
                            os = (OCTET_STRING)cb.getInterpretedCert();
                            Certificate cert = (Certificate)ASN1Util.decode((ASN1Template)Certificate.getTemplate(), (byte[])os.toByteArray());
                            cert.getInfo().print(System.out);
                            continue;
                        }
                        System.out.println("Unrecognized cert type");
                        continue;
                    }
                    System.out.println("content is ANY");
                }
                if (authSafes.safeContentsIsEncrypted(i)) {
                    newAuthSafes.addEncryptedSafeContents(AuthenticatedSafes.DEFAULT_KEY_GEN_ALG, newPass, null, 1, safeContents);
                    continue;
                }
                newAuthSafes.addSafeContents(safeContents);
            }
            PFX newPfx = new PFX(newAuthSafes);
            newPfx.computeMacData(newPass, null, 1);
            FileOutputStream fos = new FileOutputStream(args[2]);
            newPfx.encode((OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

