/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.jss.tomcat;

import java.security.KeyManagementException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.dogtagpki.jss.tomcat.TomcatJSS;
import org.mozilla.jss.JSSProvider;
import org.mozilla.jss.provider.javax.crypto.JSSKeyManager;
import org.mozilla.jss.provider.javax.crypto.JSSTrustManager;
import org.mozilla.jss.ssl.javax.JSSEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSSContext
implements org.apache.tomcat.util.net.SSLContext {
    public static Logger logger = LoggerFactory.getLogger(JSSContext.class);
    private SSLContext ctx;
    private String alias;
    private JSSKeyManager jkm;
    private JSSTrustManager jtm;

    public JSSContext(String alias) {
        logger.debug("JSSContext(" + alias + ")");
        this.alias = alias;
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("NssX509", "Mozilla-JSS");
            this.jkm = (JSSKeyManager)kmf.getKeyManagers()[0];
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("NssX509", "Mozilla-JSS");
            this.jtm = (JSSTrustManager)tmf.getTrustManagers()[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void init(KeyManager[] kms, TrustManager[] tms, SecureRandom sr) throws KeyManagementException {
        logger.debug("JSSContext.init(...)");
        try {
            String provider = "SunJSSE";
            if (JSSProvider.ENABLE_JSSENGINE) {
                provider = "Mozilla-JSS";
            }
            this.ctx = SSLContext.getInstance("TLS", provider);
            this.ctx.init(kms, tms, sr);
        }
        catch (Exception e) {
            throw new KeyManagementException(e.getMessage(), e);
        }
    }

    public SSLEngine createSSLEngine() {
        logger.debug("JSSContext.createSSLEngine()");
        SSLEngine eng = this.ctx.createSSLEngine();
        TomcatJSS instance = TomcatJSS.getInstance();
        if (eng instanceof JSSEngine) {
            JSSEngine j_eng = (JSSEngine)eng;
            j_eng.setCertFromAlias(this.alias);
            if (instance != null) {
                j_eng.setListeners(instance.getSocketListeners());
            }
        }
        return eng;
    }

    public SSLSessionContext getServerSessionContext() {
        logger.debug("JSSContext.getServerSessionContext()");
        return this.ctx.getServerSessionContext();
    }

    public SSLServerSocketFactory getServerSocketFactory() {
        logger.debug("JSSContext.getServerSocketFactory()");
        return this.ctx.getServerSocketFactory();
    }

    public SSLParameters getSupportedSSLParameters() {
        logger.debug("JSSContext.getSupportedSSLParameters()");
        return this.ctx.getSupportedSSLParameters();
    }

    public X509Certificate[] getCertificateChain(String alias) {
        logger.debug("JSSContext.getCertificateChain(" + alias + ")");
        try {
            return this.jkm.getCertificateChain(alias);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        logger.debug("JSSContext.getAcceptedIssuers()");
        try {
            return this.jtm.getAcceptedIssuers();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public void destroy() {
        logger.debug("JSSContext.destroy()");
    }
}

