/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.jss.tomcat;

import java.nio.channels.SocketChannel;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.openssl.ciphers.Cipher;
import org.dogtagpki.jss.tomcat.JSSSecureNioChannel;

public class JSSNioEndpoint
extends NioEndpoint {
    private static final Log log = LogFactory.getLog(NioEndpoint.class);

    protected boolean setSocketOptions(SocketChannel socket) {
        NioEndpoint.NioSocketWrapper socketWrapper = null;
        try {
            Object channel = null;
            if (this.getNioChannels() != null) {
                channel = (NioChannel)this.getNioChannels().pop();
            }
            if (channel == null) {
                SocketBufferHandler bufhandler = new SocketBufferHandler(this.socketProperties.getAppReadBufSize(), this.socketProperties.getAppWriteBufSize(), this.socketProperties.getDirectBuffer());
                channel = this.isSSLEnabled() ? new JSSSecureNioChannel(bufhandler, this) : new NioChannel(bufhandler);
            }
            NioEndpoint.NioSocketWrapper newWrapper = new NioEndpoint.NioSocketWrapper(channel, (NioEndpoint)this);
            channel.reset(socket, newWrapper);
            this.connections.put(socket, newWrapper);
            socketWrapper = newWrapper;
            socket.configureBlocking(false);
            if (this.getUnixDomainSocketPath() == null) {
                this.socketProperties.setProperties(socket.socket());
            }
            socketWrapper.setReadTimeout((long)this.getConnectionTimeout());
            socketWrapper.setWriteTimeout((long)this.getConnectionTimeout());
            socketWrapper.setKeepAliveLeft(this.getMaxKeepAliveRequests());
            this.getPoller().register(socketWrapper);
            return true;
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            try {
                log.error((Object)sm.getString("endpoint.socketOptionsError"), t);
            }
            catch (Throwable tt) {
                ExceptionUtils.handleThrowable((Throwable)tt);
            }
            if (socketWrapper == null) {
                this.destroySocket(socket);
            }
            return false;
        }
    }

    protected SSLEngine createSSLEngine(String arg0, List<Cipher> arg1, List<String> arg2) {
        return super.createSSLEngine(arg0, arg1, arg2);
    }
}

