/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.cert.X509Certificate;
import java.util.Base64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateChainTest {
    public static Logger logger = LoggerFactory.getLogger(CertificateChainTest.class);
    public X509Certificate rootCA = new X509CertImpl(Base64.getDecoder().decode("MIIDRjCCAi6gAwIBAgIJAMHiDXjnZ1J6MA0GCSqGSIb3DQEBCwUAMDgxEDAOBgNVBAoMB0VYQU1QTEUxJDAiBgNVBAMMG1Jvb3QgQ0EgU2lnbmluZyBDZXJ0aWZpY2F0ZTAeFw0xOTAzMDUxNzQzMjFaFw0yMDAzMDQxNzQzMjFaMDgxEDAOBgNVBAoMB0VYQU1QTEUxJDAiBgNVBAMMG1Jvb3QgQ0EgU2lnbmluZyBDZXJ0aWZpY2F0ZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMDv7ovkD+JVEdlLncYDnhzbLOz2c3D37fobufnHHNwNOwfLZj8WdBCzwGJv+XGF+D2JIcKyYwYPR+HOg+xClhuuVleEgMVvgxM+HcpM4heyBD2QczNo1dfXQRBy2AXvRn8Byh+Q6zbN7VoNu8ZaMQOxZx9mEAiDZ7WxHVrEp2a4QrI6I9gKY6SyEHRzVT48JElLFokwhkMpF8vhgtj0Xxr5EEIYyCMOzvZLtpeyH8PUri3Cv/hX1RZKjWqKLSJSKirnZLhZoEEzXtsOmoeeZBeRiabidPLsxqPfWFx4+BC7t5Vw5FaIt2mPh+q6bjZipO4uWz/p4a9wpqakuzgNsYUCAwEAAaNTMFEwHQYDVR0OBBYEFCvlfY9OzAVsYpJEoqr7QfguO9v5MB8GA1UdIwQYMBaAFCvlfY9OzAVsYpJEoqr7QfguO9v5MA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAHB1lWjT6bP1jAkk6eTVwBU2pGoGoYMGV3fWQGOmWQP5T7+nHKkUjNMRACoC2hFlypwX8qQ70V5O4U+qrnxDP3EaT1zPsOB0x4DIIrpFgudL9EqnSbJ0kvSz3awwO8x/Nvx7TatCncmTw9c14eqek2puhcQWvxHzWkaDHd9WxPrZJFftbSsnZGK2A/ybDCnUA5BDeCSDb5gufTd8gbS4wS1NwYcbbrQyHnLJlFcIF4aLkbYuX1bncYp8pQv3pZ3C/ofA+yBJvPELTaHjDC40MTdjFFfMQTPZswBX2iimoGQ/ProBGg7+rLg2uk5AHff3oo/V1X0SSzo3IpvHh0jhg9I="));
    public X509Certificate subCA = new X509CertImpl(Base64.getDecoder().decode("MIIC8zCCAdsCCQCPJrl0/W/nMTANBgkqhkiG9w0BAQsFADA4MRAwDgYDVQQKDAdFWEFNUExFMSQwIgYDVQQDDBtSb290IENBIFNpZ25pbmcgQ2VydGlmaWNhdGUwHhcNMTkwMzA1MTg1MzMzWhcNMjAwMzA0MTg1MzMzWjA/MRAwDgYDVQQKDAdFWEFNUExFMSswKQYDVQQDDCJTdWJvcmRpbmF0ZSBDQSBTaWduaW5nIENlcnRpZmljYXRlMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAzop7/TcsWElVMjzjaaAcj5KHc9H6rqhFmOsL/VYdbNzTkZD3i5DVB4sFFEHTMwEoKKpBKh9hkY8laRUWjtidDJu2+NBPLJa+k0Q+KUWIQko1rtgSjmCN+oMZFh7Mo8fV1WLSBnNjwbUrMeRKxOaR/roaYgIwH5Ra6cxsVHGngAfrjXPtiuFp7qjzUbbRBBRP2LpKDk45RzllSLhz09qgo135by2zErfUsWoma+dzvfWVI27um2DEzHMMAHELZM6BSJEYaGUW+y4cHQuuhz6Bo1YYL6RHp6RhuMzlILN7a/XznS6Zc8OV/hRlkZVUUha6tqSQ/uXNTaefa6sGrRWNdQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQAKLJq6bCZ8f/bI1OAeRNE7eIZliDnTjLqMM3sG9gkWCp1l7UD5CLAbCaL6jFEuBAvkr88LYS4A0vuMAmMVsiSsFRTZNLmazts7NZARuOYmzuNb/SZzhOBgypo6G96cqLhslzFtxXs+zJic2lQEDu+5+pcZCyETWoBTkD9sAM2dM1I9//05UTJ5mzuLFmW3rhSjsrOuYHJjwagUVVAYDrIqNgNb/XSlmWbud1t9sKHgHzN2H0DIsKaoupPhTDUABrDuG3mRn1gI2xu1RlluaXZB7ZpUZAB/hMTV8JPbHZeV08qYlfWJqhnUAZ0YQOx0yi5D98uhYB6Is/msBQ/YIbEi"));
    public X509Certificate admin = new X509CertImpl(Base64.getDecoder().decode("MIIC5DCCAcwCCQCh59LykL9CDTANBgkqhkiG9w0BAQsFADA/MRAwDgYDVQQKDAdFWEFNUExFMSswKQYDVQQDDCJTdWJvcmRpbmF0ZSBDQSBTaWduaW5nIENlcnRpZmljYXRlMB4XDTE5MDMwNTIwMDQxNloXDTIwMDMwNDIwMDQxNlowKTEQMA4GA1UECgwHRVhBTVBMRTEVMBMGCgmSJomT8ixkAQEMBWFkbWluMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA7QR+I7nLeGFntCajqIETKZ2MtpXdnrU3nkJawKwi1xQplYhFoVIqGqiX1+LfopemmR1bv2hcLt9uce4FG8jtELEF5KuCdCT99BSi8iVU+w0zs4kCfUj9HvIcFhUO0dhkyVI//ZDh16xOi5AS3jqB0PtjgYbdrmufxXQhnyoeY9CMN/w8OmN7mx2xUIApFP2LldU21rNSvly2Q0JbVDN2q7EENViYovvELW7zALGT5l/uwVUsdkdgKY2C0ZHCh+aUDvDogywIALJIRxjcCU3Udx8Vfq/+MZCNccj6CPeCxNFvL/wNtu+MpboF1jwNZB5jK9FPr3lXaH1aDdxoBSDMVwIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQApkTNJMiCOYi9MI79kHFbEESd/ae+TTvHAd7sBIe5u1v5yK5Ij2opKorY+gCVwNQOUlR7P/FIaY4eLVfPswqr3pl6O/DyqcuMLZofOHAzPEIBPFV/Qxcu1WB1SDnSW61Wx7khVnWJQPgbcPVHdgTSS4vmUOw3YAsFAqzczth6bw/5sD19WLVu6OYTSFGiofFLZXkidxZ7DIP2TUsaFJUEOkdoXlAImaHGpsCB/NXj2bWRmbzxcnMxdjxttLewQofszMM0extB95n1KFv/bzbD+m9NM+aqvLOrzOg5rlcE5cbU07DVIycYsfszFfR+9FvzA/AOpUzHg8y+ZX1rUts5f"));

    @Test
    public void testDefaultConstructor() throws Exception {
        CertificateChain chain = new CertificateChain();
        Assertions.assertEquals((int)0, (int)chain.getCertificates().size());
    }

    @Test
    public void testConstructorWithNullCert() throws Exception {
        try {
            new CertificateChain((X509Certificate)null);
            Assertions.fail((String)"Creating CertificateChain with null cert should fail");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Missing input certificate", (Object)e.getMessage());
        }
    }

    @Test
    public void testConstructorWithRootCA() throws Exception {
        CertificateChain chain = new CertificateChain(this.rootCA);
        Assertions.assertEquals((int)1, (int)chain.getCertificates().size());
        Assertions.assertEquals((Object)this.rootCA, chain.getCertificates().get(0));
    }

    @Test
    public void testConstructorWithNullCertArray() throws Exception {
        try {
            new CertificateChain((X509Certificate[])null);
            Assertions.fail((String)"Creating CertificateChain with null cert array should fail");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertEquals((Object)"Missing input certificates", (Object)e.getMessage());
        }
    }

    @Test
    public void testConstructorWithEmptyCertArray() throws Exception {
        CertificateChain chain = new CertificateChain(new X509Certificate[0]);
        Assertions.assertEquals((int)0, (int)chain.getCertificates().size());
    }

    @Test
    public void testConstructorWithOneCert() throws Exception {
        CertificateChain chain = new CertificateChain(new X509Certificate[]{this.rootCA});
        Assertions.assertEquals((int)1, (int)chain.getCertificates().size());
        Assertions.assertEquals((Object)this.rootCA, chain.getCertificates().get(0));
    }

    @Test
    public void testConstructorWithTwoCerts() throws Exception {
        CertificateChain chain = new CertificateChain(new X509Certificate[]{this.rootCA, this.subCA});
        Assertions.assertEquals((int)2, (int)chain.getCertificates().size());
        Assertions.assertEquals((Object)this.rootCA, chain.getCertificates().get(0));
        Assertions.assertEquals((Object)this.subCA, chain.getCertificates().get(1));
    }

    @Test
    public void testGetterMethods() throws Exception {
        CertificateChain chain = new CertificateChain(new X509Certificate[]{this.rootCA, this.subCA, this.admin});
        Assertions.assertEquals((int)3, (int)chain.getCertificates().size());
        Assertions.assertEquals((Object)this.rootCA, (Object)chain.getFirstCertificate());
        Assertions.assertEquals((Object)this.rootCA, (Object)chain.getCertificate(0));
        Assertions.assertEquals((Object)this.subCA, (Object)chain.getCertificate(1));
        Assertions.assertEquals((Object)this.admin, (Object)chain.getCertificate(2));
        try {
            chain.getCertificate(3);
            Assertions.fail((String)"Getting cert #3 should fail");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        X509Certificate[] certs = chain.getChain();
        Assertions.assertEquals((int)3, (int)certs.length);
        Assertions.assertEquals((Object)this.rootCA, (Object)certs[0]);
        Assertions.assertEquals((Object)this.subCA, (Object)certs[1]);
        Assertions.assertEquals((Object)this.admin, (Object)certs[2]);
    }

    @Test
    public void testSorting() throws Exception {
        CertificateChain chain = new CertificateChain(new X509Certificate[]{this.admin, this.subCA, this.rootCA});
        chain.sort();
        Assertions.assertEquals((int)3, (int)chain.getCertificates().size());
        Assertions.assertEquals((Object)this.rootCA, (Object)chain.getCertificate(0));
        Assertions.assertEquals((Object)this.subCA, (Object)chain.getCertificate(1));
        Assertions.assertEquals((Object)this.admin, (Object)chain.getCertificate(2));
    }
}

