/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.cmmf;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.asn1.UTF8String;

public class PKIStatusInfo
implements ASN1Value {
    private INTEGER status;
    private SEQUENCE statusString;
    private int failInfo;
    private boolean hasFailInfo;
    public static final int granted = 0;
    public static final int grantedWithMods = 1;
    public static final int rejection = 2;
    public static final int waiting = 3;
    public static final int revocationWarning = 4;
    public static final int revocationNotification = 5;
    public static final int keyUpdateWarning = 6;
    public static final int badAlg = Integer.MIN_VALUE;
    public static final int badMessageCheck = 0x40000000;
    public static final int badRequest = 0x20000000;
    public static final int badTime = 0x10000000;
    public static final int badCertId = 0x8000000;
    public static final int badDataFormat = 0x4000000;
    public static final int wrongAuthority = 0x2000000;
    public static final int incorrectData = 0x1000000;
    public static final int missingTimeStamp = 0x800000;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public PKIStatusInfo(int status, int failInfo) {
        this.status = new INTEGER(status);
        this.statusString = new SEQUENCE();
        this.failInfo = failInfo;
        this.hasFailInfo = true;
    }

    public PKIStatusInfo(int status) {
        this.status = new INTEGER(status);
        this.statusString = new SEQUENCE();
        this.hasFailInfo = false;
    }

    public void setStatusString(SEQUENCE statusString) {
        this.statusString = statusString;
    }

    public void addFreeText(String s) {
        try {
            this.statusString.addElement(new UTF8String(s));
        }
        catch (CharConversionException e) {
            throw new RuntimeException("Error encoding to UTF8: " + e.getMessage(), e);
        }
    }

    public void addFreeText(UTF8String s) {
        this.statusString.addElement(s);
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement(this.status);
        if (this.statusString.size() > 0) {
            seq.addElement(this.statusString);
        }
        if (this.hasFailInfo) {
            byte[] bytes = new byte[]{(byte)((this.failInfo & 0xFF000000) >>> 24), (byte)((this.failInfo & 0xFF0000) >>> 16)};
            int padCount = 7;
            BIT_STRING bs = new BIT_STRING(bytes, padCount);
            bs.setRemoveTrailingZeroes(true);
            seq.addElement(bs);
        }
        seq.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addOptionalElement(new SEQUENCE.OF_Template(UTF8String.getTemplate()));
            this.seqt.addOptionalElement(BIT_STRING.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            PKIStatusInfo psi;
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            BIT_STRING failInfo = (BIT_STRING)seq.elementAt(2);
            if (failInfo == null) {
                psi = new PKIStatusInfo(((INTEGER)seq.elementAt(0)).intValue());
            } else {
                BitSet bs = failInfo.toBitSet();
                int failinfo = 0;
                int i = 0;
                for (int bit = Integer.MIN_VALUE; bit != 0; bit >>>= 1) {
                    if (bs.get(i)) {
                        failinfo |= bit;
                    }
                    ++i;
                }
                psi = new PKIStatusInfo(((INTEGER)seq.elementAt(0)).intValue(), failinfo);
            }
            psi.setStatusString((SEQUENCE)seq.elementAt(1));
            return psi;
        }
    }
}

