/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs12;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.IA5String;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;

public class CertBag
implements ASN1Value {
    private static final OBJECT_IDENTIFIER CERT_TYPES = OBJECT_IDENTIFIER.PKCS9.subBranch(22L);
    public static final OBJECT_IDENTIFIER X509_CERT_TYPE = CERT_TYPES.subBranch(1L);
    public static final OBJECT_IDENTIFIER SDSI_CERT_TYPE = CERT_TYPES.subBranch(2L);
    private OBJECT_IDENTIFIER certType;
    private ANY cert;
    private SEQUENCE sequence;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public OBJECT_IDENTIFIER getCertType() {
        return this.certType;
    }

    public ANY getCert() {
        return this.cert;
    }

    public ASN1Value getInterpretedCert() throws InvalidBERException {
        if (this.certType.equals(X509_CERT_TYPE)) {
            return this.cert.decodeWith(OCTET_STRING.getTemplate());
        }
        if (this.certType.equals(SDSI_CERT_TYPE)) {
            return this.cert.decodeWith(IA5String.getTemplate());
        }
        return this.cert;
    }

    public CertBag(OBJECT_IDENTIFIER certType, ASN1Value cert) {
        if (certType == null || cert == null) {
            throw new IllegalArgumentException("certType or cert is null");
        }
        this.certType = certType;
        if (cert instanceof ANY) {
            this.cert = (ANY)cert;
        } else {
            try {
                byte[] encoded = ASN1Util.encode(cert);
                this.cert = (ANY)ASN1Util.decode(ANY.getTemplate(), encoded);
            }
            catch (InvalidBERException e) {
                throw new RuntimeException("Unable to convert ASN1Value to ANY: " + e.getMessage(), e);
            }
        }
        this.sequence = new SEQUENCE();
        this.sequence.addElement(this.certType);
        this.sequence.addElement(new EXPLICIT(new Tag(0L), this.cert));
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.sequence.encode(ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        this.sequence.encode(implicitTag, ostream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(OBJECT_IDENTIFIER.getTemplate());
            this.seqt.addElement(new EXPLICIT.Template(new Tag(0L), ANY.getTemplate()));
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            return new CertBag((OBJECT_IDENTIFIER)seq.elementAt(0), ((EXPLICIT)seq.elementAt(1)).getContent());
        }
    }
}

