/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs12;

import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.NotInitializedException;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BMPString;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.JSSSecureRandom;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs12.AuthenticatedSafes;
import org.mozilla.jss.pkcs12.CertBag;
import org.mozilla.jss.pkcs12.MacData;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs12.SafeBag;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.DigestInfo;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.Attribute;
import org.mozilla.jss.pkix.primitive.EncryptedPrivateKeyInfo;
import org.mozilla.jss.pkix.primitive.PrivateKeyInfo;
import org.mozilla.jss.util.Password;

public class PFX
implements ASN1Value {
    private INTEGER version;
    private AuthenticatedSafes authSafes;
    private MacData macData;
    private byte[] encodedAuthSafes;
    private static final INTEGER VERSION = new INTEGER(3L);
    public static final int DEFAULT_ITERATIONS = 1;
    private static final Tag TAG = SEQUENCE.TAG;

    public INTEGER getVersion() {
        return this.version;
    }

    public AuthenticatedSafes getAuthSafes() {
        return this.authSafes;
    }

    public MacData getMacData() {
        return this.macData;
    }

    private void setEncodedAuthSafes(byte[] encodedAuthSafes) {
        this.encodedAuthSafes = encodedAuthSafes;
    }

    public boolean verifyAuthSafes(Password password, StringBuffer reason) throws NotInitializedException {
        try {
            if (reason == null) {
                reason = new StringBuffer();
            }
            if (this.macData == null) {
                reason.append("No MAC present in PFX");
                return false;
            }
            if (this.encodedAuthSafes == null) {
                this.encodedAuthSafes = ASN1Util.encode(this.authSafes);
            }
            DigestInfo macDataMac = this.macData.getMac();
            MacData testMac = new MacData(password, this.macData.getMacSalt().toByteArray(), this.macData.getMacIterationCount().intValue(), this.encodedAuthSafes, this.macData.getMac().getDigestAlgorithm());
            if (testMac.getMac().equals(macDataMac)) {
                return true;
            }
            reason.append("Digests do not match");
            return false;
        }
        catch (DigestException e) {
            reason.append("A DigestException occurred");
            return false;
        }
        catch (TokenException e) {
            reason.append("A TokenException occurred");
            return false;
        }
        catch (CharConversionException e) {
            reason.append("An exception occurred converting the password from chars to bytes");
            return false;
        }
    }

    public PFX(INTEGER version, AuthenticatedSafes authSafes, MacData macData) {
        if (version == null || authSafes == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this.version = version;
        this.authSafes = authSafes;
        this.macData = macData;
    }

    public PFX(AuthenticatedSafes authSafes, MacData macData) {
        this(VERSION, authSafes, macData);
    }

    public PFX(AuthenticatedSafes authSafes) {
        this(VERSION, authSafes, null);
    }

    public void computeMacData(Password password, byte[] salt, int iterationCount) throws NotInitializedException, DigestException, TokenException, CharConversionException {
        this.macData = new MacData(password, salt, iterationCount, ASN1Util.encode(this.authSafes));
    }

    @Override
    public Tag getTag() {
        return TAG;
    }

    @Override
    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    @Override
    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        seq.addElement(this.version);
        seq.addElement(new ContentInfo(ASN1Util.encode(this.authSafes)));
        if (this.macData != null) {
            seq.addElement(this.macData);
        }
        seq.encode(implicitTag, ostream);
    }

    public static void main(String[] args) {
        try {
            PFX pfx;
            if (args.length != 2) {
                System.out.println("Usage: PFX <dbdir> <infile>");
                System.exit(-1);
            }
            int certfile = 0;
            CryptoManager.initialize(args[0]);
            Template pfxt = new Template();
            FileInputStream fis = new FileInputStream(args[1]);
            try (BufferedInputStream in = new BufferedInputStream(fis, 2048);){
                pfx = (PFX)pfxt.decode(in);
            }
            System.out.println("Decoded PFX");
            System.out.println("Version: " + pfx.getVersion());
            AuthenticatedSafes authSafes = pfx.getAuthSafes();
            SEQUENCE asSeq = authSafes.getSequence();
            System.out.println("AuthSafes has " + asSeq.size() + " SafeContents");
            System.out.println("Enter password: ");
            Password pass = Password.readPasswordFromConsole();
            System.out.println("Enter new password:");
            Password newPass = Password.readPasswordFromConsole();
            StringBuffer sb = new StringBuffer();
            if (pfx.verifyAuthSafes(pass, sb)) {
                System.out.println("AuthSafes verifies correctly");
            } else {
                System.out.println("AuthSafes failed to verify because: " + sb);
            }
            AuthenticatedSafes newAuthSafes = new AuthenticatedSafes();
            for (int i = 0; i < asSeq.size(); ++i) {
                SEQUENCE safeContents = authSafes.getSafeContentsAt(pass, i);
                System.out.println("\n\nSafeContents #" + i + " has " + safeContents.size() + " bags");
                for (int j = 0; j < safeContents.size(); ++j) {
                    OCTET_STRING os;
                    SafeBag safeBag = (SafeBag)safeContents.elementAt(j);
                    System.out.println("\nBag " + j + " has type " + safeBag.getBagType());
                    SET attribs = safeBag.getBagAttributes();
                    if (attribs == null) {
                        System.out.println("Bag has no attributes");
                    } else {
                        for (int b = 0; b < attribs.size(); ++b) {
                            Attribute a = (Attribute)attribs.elementAt(b);
                            if (a.getType().equals(SafeBag.FRIENDLY_NAME)) {
                                BMPString bs = (BMPString)((ANY)a.getValues().elementAt(0)).decodeWith(BMPString.getTemplate());
                                System.out.println("Friendly Name: " + bs);
                                continue;
                            }
                            if (a.getType().equals(SafeBag.LOCAL_KEY_ID)) {
                                os = (OCTET_STRING)((ANY)a.getValues().elementAt(0)).decodeWith(OCTET_STRING.getTemplate());
                                System.out.println("LocalKeyID:");
                                AuthenticatedSafes.print_byte_array(os.toByteArray());
                                continue;
                            }
                            System.out.println("Unknown attribute type");
                        }
                    }
                    ASN1Value val = safeBag.getInterpretedBagContent();
                    if (val instanceof PrivateKeyInfo) {
                        System.out.println("content is PrivateKeyInfo");
                        continue;
                    }
                    if (val instanceof EncryptedPrivateKeyInfo) {
                        EncryptedPrivateKeyInfo epki = (EncryptedPrivateKeyInfo)val;
                        System.out.println("content is EncryptedPrivateKeyInfo, algoid:" + epki.getEncryptionAlgorithm().getOID());
                        PrivateKeyInfo pki = epki.decrypt(pass, new PasswordConverter());
                        byte[] salt = new byte[20];
                        JSSSecureRandom rand = CryptoManager.getInstance().getSecureRNG();
                        rand.nextBytes(salt);
                        epki = EncryptedPrivateKeyInfo.createPBE(PBEAlgorithm.PBE_SHA1_DES3_CBC, newPass, salt, 1, new PasswordConverter(), pki);
                        safeContents.insertElementAt(new SafeBag(safeBag.getBagType(), epki, safeBag.getBagAttributes()), j);
                        safeContents.removeElementAt(j + 1);
                        continue;
                    }
                    if (val instanceof CertBag) {
                        System.out.println("   content is CertBag");
                        CertBag cb = (CertBag)val;
                        if (cb.getCertType().equals(CertBag.X509_CERT_TYPE)) {
                            os = (OCTET_STRING)cb.getInterpretedCert();
                            FileOutputStream fos = new FileOutputStream("cert" + certfile++ + ".der");
                            os.encode(fos);
                            fos.close();
                            Certificate cert = (Certificate)ASN1Util.decode(Certificate.getTemplate(), os.toByteArray());
                            cert.getInfo().print(System.out);
                            continue;
                        }
                        System.out.println("Unrecognized cert type");
                        continue;
                    }
                    System.out.println("content is ANY");
                }
                if (authSafes.safeContentsIsEncrypted(i)) {
                    newAuthSafes.addEncryptedSafeContents(AuthenticatedSafes.DEFAULT_KEY_GEN_ALG, newPass, null, 1, safeContents);
                    continue;
                }
                newAuthSafes.addSafeContents(safeContents);
            }
            PFX newPfx = new PFX(newAuthSafes);
            newPfx.computeMacData(newPass, null, 1);
            FileOutputStream fos = new FileOutputStream("newjss.p12");
            newPfx.encode(fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = SEQUENCE.getTemplate();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(ContentInfo.getTemplate());
            this.seqt.addOptionalElement(MacData.getTemplate());
        }

        @Override
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        @Override
        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        @Override
        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            ContentInfo authSafesCI = (ContentInfo)seq.elementAt(1);
            if (!authSafesCI.getContentType().equals(ContentInfo.DATA)) {
                throw new InvalidBERException("ContentInfo containing AuthenticatedSafes does not have content-type DATA");
            }
            OCTET_STRING authSafesOS = (OCTET_STRING)authSafesCI.getInterpretedContent();
            AuthenticatedSafes authSafes = (AuthenticatedSafes)ASN1Util.decode(AuthenticatedSafes.getTemplate(), authSafesOS.toByteArray());
            PFX pfx = new PFX((INTEGER)seq.elementAt(0), authSafes, (MacData)seq.elementAt(2));
            pfx.setEncodedAuthSafes(authSafesOS.toByteArray());
            return pfx;
        }
    }
}

