/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.IOException;
import java.io.InputStream;
import org.mozilla.jss.ssl.SSLSocket;

class SSLInputStream
extends InputStream {
    private SSLSocket sock;

    SSLInputStream(SSLSocket sock) {
        this.sock = sock;
    }

    @Override
    public int available() throws IOException {
        return this.sock.socketAvailable();
    }

    @Override
    public void close() throws IOException {
        this.sock.close();
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        int nread = this.read(b, 0, 1);
        if (nread == -1) {
            return nread;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.sock.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        int nread;
        long numSkipped = 0L;
        int size = (int)(n < 2048L ? n : 2048L);
        byte[] trash = new byte[size];
        while (n > 0L && (nread = this.read(trash, 0, size = (int)(n < 2048L ? n : 2048L))) > 0) {
            numSkipped += (long)nread;
            n -= (long)nread;
        }
        return numSkipped;
    }
}

