/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl.javax;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.EventListener;
import java.util.Set;
import org.mozilla.jss.ssl.javax.JSSEngine;
import org.mozilla.jss.ssl.javax.JSSServerSocket;
import org.mozilla.jss.ssl.javax.JSSSocket;
import org.mozilla.jss.ssl.javax.JSSSocketChannel;

public class JSSServerSocketChannel
extends ServerSocketChannel {
    private JSSServerSocket sslSocket;
    private ServerSocketChannel parent;
    private ServerSocket parentSocket;
    private JSSEngine engine;

    public JSSServerSocketChannel(JSSServerSocket sslSocket, ServerSocketChannel parent, JSSEngine engine) throws IOException {
        super(null);
        this.sslSocket = sslSocket;
        this.parent = parent;
        this.parentSocket = parent.socket();
        this.engine = engine;
        this.configureBlocking(parent.isBlocking());
    }

    public JSSServerSocketChannel(JSSServerSocket sslSocket, ServerSocket parentSocket, JSSEngine engine) throws IOException {
        super(null);
        this.sslSocket = sslSocket;
        this.parentSocket = parentSocket;
        this.engine = engine;
        this.configureBlocking(false);
    }

    @Override
    public JSSSocketChannel accept() throws IOException {
        if (this.parent == null) {
            Object msg = "Unable to accept() on a JSSServerSocketChannel ";
            msg = (String)msg + "which wraps a blocking ServerSocket lacking a channel.";
            throw new IOException((String)msg);
        }
        SocketChannel acceptedChannel = this.parent.accept();
        if (acceptedChannel == null) {
            return null;
        }
        Socket acceptedSocket = acceptedChannel.socket();
        JSSSocket sslAcceptedSocket = this.sslSocket.acceptSocket(acceptedSocket);
        return sslAcceptedSocket.getChannel();
    }

    @Override
    public JSSServerSocketChannel bind(SocketAddress local, int backlog) throws IOException {
        if (this.parent == null) {
            this.parentSocket.bind(local, backlog);
            return this;
        }
        this.parent.bind(local, backlog);
        return this;
    }

    public void setListeners(Collection<? extends EventListener> listeners) {
        this.engine.setListeners(listeners);
    }

    public Collection<? extends EventListener> getListeners() {
        return this.engine.getListeners();
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.supportedOptions();
    }

    @Override
    public <T> JSSServerSocketChannel setOption(SocketOption<T> name, T value) throws IOException {
        if (this.parent != null) {
            this.parent.setOption((SocketOption)name, (Object)value);
        }
        return this;
    }

    @Override
    public JSSServerSocket socket() {
        return this.sslSocket;
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        if (this.parent == null) {
            return this.parentSocket.getLocalSocketAddress();
        }
        return this.parent.getLocalAddress();
    }

    @Override
    public void implCloseSelectableChannel() throws IOException {
        this.engine.cleanup();
        this.engine = null;
        if (this.parent == null) {
            this.parentSocket.close();
            return;
        }
        this.parent.close();
    }

    @Override
    public void implConfigureBlocking(boolean block) throws IOException {
        if (this.parent == null) {
            return;
        }
        this.parent.configureBlocking(block);
    }
}

