/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl.javax;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Set;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.mozilla.jss.pkcs11.PK11Cert;
import org.mozilla.jss.pkcs11.PK11PrivKey;
import org.mozilla.jss.provider.javax.crypto.JSSTrustManager;
import org.mozilla.jss.ssl.javax.JSSEngine;
import org.mozilla.jss.ssl.javax.JSSParameters;
import org.mozilla.jss.ssl.javax.JSSSocketChannel;

public class JSSSocket
extends SSLSocket {
    private String engineProviderProtocol = "TLS";
    private String engineProvider = "Mozilla-JSS";
    private SSLContext jssContext;
    private JSSEngine engine;
    private ArrayList<HandshakeCompletedListener> handshakeCallbacks = new ArrayList();
    private Socket parent;
    private InputStream consumedData;
    private JSSSocketChannel channel;
    private boolean autoClose = true;
    private boolean closed;

    public void consumeSocket(Socket parent) throws IOException {
        if (parent == null) {
            String msg = "Unable to consume and utilize null parent socket!";
            throw new IOException(msg);
        }
        if (this.closed) {
            String msg = "Unable to perform operations on a closed socket!";
            throw new IOException(msg);
        }
        this.parent = parent;
    }

    protected SSLContext getSSLContext() throws IOException {
        if (this.closed) {
            String msg = "Unable to perform operations on a closed socket!";
            throw new IOException(msg);
        }
        if (this.jssContext == null) {
            try {
                this.jssContext = SSLContext.getInstance(this.engineProviderProtocol, this.engineProvider);
            }
            catch (Exception e) {
                Object msg = "Unable to create JSSSocket prior to Mozilla-JSS ";
                msg = (String)msg + "initialization! " + e.getMessage();
                throw new IOException((String)msg, e);
            }
        }
        return this.jssContext;
    }

    public void setSSLContext(SSLContext ctx) {
        this.jssContext = ctx;
    }

    private void init() throws IOException {
        SocketChannel parentChannel;
        if (this.closed) {
            String msg = "Unable to perform operations on a closed socket!";
            throw new IOException(msg);
        }
        if (this.engine == null) {
            this.initEngine();
        }
        if ((parentChannel = this.parent.getChannel()) == null) {
            ReadableByteChannel read = Channels.newChannel(this.parent.getInputStream());
            WritableByteChannel write = Channels.newChannel(this.parent.getOutputStream());
            this.channel = new JSSSocketChannel(this, this.parent, read, write, this.engine);
        } else {
            this.channel = new JSSSocketChannel(this, parentChannel, this.engine);
        }
        this.channel.setConsumedData(this.consumedData);
        this.channel.setAutoClose(this.autoClose);
    }

    public void initEngine() throws IOException {
        this.engine = (JSSEngine)this.getSSLContext().createSSLEngine();
    }

    public void initEngine(String host, int port) throws IOException {
        this.engine = (JSSEngine)this.getSSLContext().createSSLEngine(host, port);
    }

    public JSSEngine getEngine() {
        return this.engine;
    }

    @Override
    public JSSSocketChannel getChannel() {
        if (this.parent.getChannel() == null) {
            return null;
        }
        return this.getInternalChannel();
    }

    protected JSSSocketChannel getInternalChannel() {
        if (this.channel == null) {
            try {
                this.init();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected error trying to construct channel: " + e.getMessage(), e);
            }
        }
        return this.channel;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.channel == null) {
            this.init();
        }
        return Channels.newInputStream(this.channel);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.channel == null) {
            this.init();
        }
        return Channels.newOutputStream(this.channel);
    }

    private void doHandshake() throws IOException {
        if (this.channel == null) {
            this.init();
        }
        boolean status = this.channel.finishConnect();
        if (!this.channel.isBlocking()) {
            int connectAttempts = 0;
            while (!status) {
                status = this.channel.finishConnect();
                try {
                    Thread.sleep((long)connectAttempts * 100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (++connectAttempts <= 25) continue;
            }
        }
        if (!status) {
            throw new IOException("Unable to finish handshake for an unknown reason.");
        }
    }

    public void setConsumedData(InputStream consumed) {
        this.consumedData = consumed;
    }

    public boolean getAutoClose() {
        return this.autoClose;
    }

    public void setAutoClose(boolean on) {
        this.autoClose = on;
        if (this.channel != null) {
            this.channel.setAutoClose(on);
        }
    }

    public void setHostname(String name) {
        this.engine.setHostname(name);
    }

    public void setCertFromAlias(String alias) throws IllegalArgumentException {
        this.engine.setCertFromAlias(alias);
    }

    public void setKeyMaterials(PK11Cert ourCert, PK11PrivKey ourKey) throws IllegalArgumentException {
        this.engine.setKeyMaterials(ourCert, ourKey);
    }

    public void setKeyManager(X509KeyManager km) {
        this.engine.setKeyManager(km);
    }

    public void setKeyManagers(X509KeyManager[] xkms) {
        this.engine.setKeyManagers(xkms);
    }

    public void setTrustManager(JSSTrustManager tm) {
        this.engine.setTrustManager(tm);
    }

    public void setTrustManagers(X509TrustManager[] xtms) {
        this.engine.setTrustManagers(xtms);
    }

    public void setListeners(Collection<? extends EventListener> listeners) {
        this.engine.setListeners(listeners);
    }

    public Collection<? extends EventListener> getListeners() {
        return this.engine.getListeners();
    }

    @Override
    public void startHandshake() throws IOException {
        this.engine.beginHandshake();
        if (this.channel == null) {
            this.doHandshake();
        }
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener callback) throws IllegalArgumentException {
        if (callback == null) {
            throw new IllegalArgumentException("Expected non-null HandshakeCompletedListener instance.");
        }
        this.handshakeCallbacks.add(callback);
    }

    protected void notifyHandshakeCompletedListeners() {
        HandshakeCompletedEvent event = new HandshakeCompletedEvent(this, this.getSession());
        for (HandshakeCompletedListener callback : this.handshakeCallbacks) {
            callback.handshakeCompleted(event);
        }
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener callback) throws IllegalArgumentException {
        if (callback == null) {
            throw new IllegalArgumentException("Expected non-null HandshakeCompletedListener instance.");
        }
        if (!this.handshakeCallbacks.contains(callback)) {
            throw new IllegalArgumentException("Passed callback " + callback + " wasn't registered!");
        }
        this.handshakeCallbacks.remove(callback);
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.engine.getEnabledCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.engine.getSupportedCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.engine.setEnabledCipherSuites(suites);
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.engine.getEnabledProtocols();
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.engine.getSupportedProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.engine.setEnabledProtocols(protocols);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.engine.getEnableSessionCreation();
    }

    @Override
    public void setEnableSessionCreation(boolean enabled) {
        this.engine.setEnableSessionCreation(enabled);
    }

    @Override
    public SSLSession getHandshakeSession() {
        return this.engine.getHandshakeSession();
    }

    @Override
    public SSLSession getSession() {
        return this.engine.getSession();
    }

    @Override
    public boolean getUseClientMode() {
        return this.engine.getUseClientMode();
    }

    @Override
    public void setUseClientMode(boolean client) {
        this.engine.setUseClientMode(client);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.engine.getWantClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.engine.setWantClientAuth(want);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.engine.getNeedClientAuth();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.engine.setNeedClientAuth(need);
    }

    @Override
    public JSSParameters getSSLParameters() {
        return this.engine.getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        this.engine.setSSLParameters(params);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.parent.connect(endpoint);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.parent.connect(endpoint, timeout);
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.parent.bind(bindpoint);
    }

    @Override
    public synchronized void close() throws IOException {
        this.getInternalChannel().close();
        this.engine.cleanup();
        this.engine = null;
        this.channel = null;
        this.closed = true;
    }

    @Override
    public void shutdownInput() throws IOException {
        this.getInternalChannel().shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.getInternalChannel().shutdownOutput();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.parent.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.parent.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.parent.getPort();
    }

    @Override
    public int getLocalPort() {
        return this.parent.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.parent.getLocalSocketAddress();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.parent.getRemoteSocketAddress();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.parent.getTcpNoDelay();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.parent.setTcpNoDelay(on);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.parent.getSoLinger();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.parent.setSoLinger(on, linger);
    }

    @Override
    public synchronized int getSoTimeout() throws SocketException {
        return this.parent.getSoTimeout();
    }

    @Override
    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.parent.setSoTimeout(timeout);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.parent.getOOBInline();
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.parent.setOOBInline(on);
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        throw new IOException("Not implemented for SSLSockets!");
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        return this.parent.getSendBufferSize();
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.parent.setSendBufferSize(size);
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        return this.parent.getReceiveBufferSize();
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.parent.setReceiveBufferSize(size);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.parent.getKeepAlive();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.parent.setKeepAlive(on);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.parent.getTrafficClass();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.parent.setTrafficClass(tc);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.parent.getReuseAddress();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.parent.setReuseAddress(on);
    }

    @Override
    public boolean isConnected() {
        return this.parent.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.parent.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.parent.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.parent.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.parent.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.parent.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JSSSocket with ");
        builder.append(this.engine);
        builder.append(" over ");
        builder.append(this.parent);
        return builder.toString();
    }

    @Override
    public <T> Socket setOption(SocketOption<T> name, T value) throws IOException {
        this.getInternalChannel().setOption((SocketOption)name, (Object)value);
        return this;
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.getInternalChannel().getOption(name);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.getInternalChannel().supportedOptions();
    }
}

