/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.logging;

import com.netscape.certsrv.logging.AuditClient;
import com.netscape.certsrv.logging.AuditConfig;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.logging.AuditCLI;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditShowCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(AuditShowCLI.class);
    public AuditCLI auditCLI;

    public AuditShowCLI(AuditCLI auditCLI) {
        super("show", "Show audit configuration", (CLI)auditCLI);
        this.auditCLI = auditCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "output", true, "Output file to store audit configuration.");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 0) {
            throw new Exception("Too many arguments specified.");
        }
        String output = cmd.getOptionValue("output");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        AuditClient auditClient = this.auditCLI.getAuditClient();
        AuditConfig auditConfig = auditClient.getAuditConfig();
        if (output == null) {
            MainCLI.printMessage("Audit configuration");
            AuditCLI.printAuditConfig(auditConfig);
        } else {
            try (PrintWriter out = new PrintWriter(new FileWriter(output));){
                out.println(auditConfig.toJSON());
            }
            MainCLI.printMessage("Stored audit configuration into " + output);
        }
    }
}

