/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs11;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs11.PKCS11CertCLI;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.security.KeyStore;
import java.security.cert.Certificate;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.provider.java.security.JSSLoadStoreParameter;

public class PKCS11CertRemoveCLI
extends CommandCLI {
    public PKCS11CertCLI certCLI;

    public PKCS11CertRemoveCLI(PKCS11CertCLI certCLI) {
        super("del", "Remove PKCS #11 certificate", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] <Cert ID>", this.options);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing cert ID.");
        }
        String alias = cmdArgs[0];
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        String tokenName = this.getConfig().getTokenName();
        CryptoToken token = CryptoUtil.getKeyStorageToken((String)tokenName);
        KeyStore ks = KeyStore.getInstance("pkcs11");
        ks.load((KeyStore.LoadStoreParameter)new JSSLoadStoreParameter(token));
        Certificate cert = ks.getCertificate(alias);
        if (cert == null) {
            throw new Exception("Certificate not found: " + alias);
        }
        ks.deleteEntry(alias);
    }
}

