/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tks;

import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.tks.TKSClient;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.tks.TKSCertCLI;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.io.IOUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TKSCertTransportImportCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(TKSCertTransportImportCLI.class);
    public TKSCertCLI certCLI;

    public TKSCertTransportImportCLI(TKSCertCLI certCLI) {
        super("transport-import", "Import TKS transport certificate", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "security-domain", true, "Security domain URL");
        option.setArgName("URL");
        this.options.addOption(option);
        option = new Option(null, "session", true, "Session ID");
        option.setArgName("ID");
        this.options.addOption(option);
        option = new Option(null, "install-token", true, "Install token");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "input-format", true, "Input format: PEM (default), DER");
        option.setArgName("format");
        this.options.addOption(option);
        option = new Option(null, "input-file", true, "Input file");
        option.setArgName("file");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String url;
        String[] cmdArgs = cmd.getArgs();
        String nickname = null;
        if (cmdArgs.length >= 1) {
            nickname = cmdArgs[0];
        }
        if ((url = cmd.getOptionValue("security-domain")) == null) {
            throw new Exception("Missing security domain URL");
        }
        URI uri = new URL(url).toURI();
        String installToken = cmd.getOptionValue("install-token");
        String sessionID = installToken != null ? new String(Files.readAllBytes(Paths.get(installToken, new String[0]))) : cmd.getOptionValue("session");
        if (sessionID == null) {
            throw new Exception("Missing session ID or install token");
        }
        String filename = cmd.getOptionValue("input-file");
        byte[] bytes = filename == null ? IOUtils.toByteArray((InputStream)System.in) : Files.readAllBytes(Paths.get(filename, new String[0]));
        String format = cmd.getOptionValue("input-format");
        if (format == null || "PEM".equalsIgnoreCase(format)) {
            bytes = Cert.parseCertificate((String)new String(bytes));
        } else if (!"DER".equalsIgnoreCase(format)) {
            throw new Exception("Unsupported format: " + format);
        }
        String b64cert = Utils.base64encodeSingleLine((byte[])bytes);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        PKIClient client = this.getClient();
        TKSClient tksClient = new TKSClient(client);
        tksClient.importTransportCert(uri, nickname, b64cert, sessionID);
    }
}

