/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.tps.cert;

import com.netscape.certsrv.tps.cert.TPSCertClient;
import com.netscape.certsrv.tps.cert.TPSCertData;
import com.netscape.cmstools.tps.TPSCLI;
import com.netscape.cmstools.tps.cert.TPSCertFindCLI;
import com.netscape.cmstools.tps.cert.TPSCertShowCLI;
import org.dogtagpki.cli.CLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TPSCertCLI
extends CLI {
    public static Logger logger = LoggerFactory.getLogger(TPSCertCLI.class);
    public TPSCLI tpsCLI;
    public TPSCertClient certClient;

    public TPSCertCLI(TPSCLI tpsCLI) {
        super("cert", "Certificate management commands", (CLI)tpsCLI);
        this.tpsCLI = tpsCLI;
        this.addModule((CLI)new TPSCertFindCLI(this));
        this.addModule((CLI)new TPSCertShowCLI(this));
    }

    public TPSCertClient getTPSCertClient() throws Exception {
        if (this.certClient != null) {
            return this.certClient;
        }
        this.certClient = (TPSCertClient)this.parent.getClient("certs");
        return this.certClient;
    }

    public static void printCert(TPSCertData cert) {
        System.out.println("  Cert ID: " + cert.getID());
        if (cert.getSerialNumber() != null) {
            System.out.println("  Serial Number: " + cert.getSerialNumber());
        }
        if (cert.getSubject() != null) {
            System.out.println("  Subject: " + cert.getSubject());
        }
        if (cert.getUserID() != null) {
            System.out.println("  User ID: " + cert.getUserID());
        }
        if (cert.getTokenID() != null) {
            System.out.println("  Token ID: " + cert.getTokenID());
        }
        if (cert.getOrigin() != null) {
            System.out.println("  Origin: " + cert.getOrigin());
        }
        if (cert.getType() != null) {
            System.out.println("  Type: " + cert.getType());
        }
        if (cert.getKeyType() != null) {
            System.out.println("  Key Type: " + cert.getKeyType());
        }
        if (cert.getStatus() != null) {
            System.out.println("  Status: " + cert.getStatus());
        }
        if (cert.getCreateTime() != null) {
            System.out.println("  Create Time: " + cert.getCreateTime());
        }
        if (cert.getModifyTime() != null) {
            System.out.println("  Modify Time: " + cert.getModifyTime());
        }
    }
}

