/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.ocsp;

import com.netscape.cmsutil.ocsp.Request;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.EXPLICIT;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.cert.Extension;

public class TBSRequest
implements ASN1Value {
    private static final INTEGER v1 = new INTEGER(0L);
    private INTEGER version;
    private ANY requestorName;
    private SEQUENCE requestList;
    private SEQUENCE requestExtensions;
    public static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public INTEGER getVersion() {
        return this.version;
    }

    public ANY getRequestorName() {
        return this.requestorName;
    }

    public int getRequestCount() {
        return this.requestList == null ? 0 : this.requestList.size();
    }

    public Request getRequestAt(int index) {
        return (Request)this.requestList.elementAt(index);
    }

    public int getExtensionsCount() {
        return this.requestExtensions == null ? 0 : this.requestExtensions.size();
    }

    public Extension getRequestExtensionAt(int index) {
        return (Extension)this.requestExtensions.elementAt(index);
    }

    public TBSRequest(INTEGER version, ANY requestorName, SEQUENCE requestList, SEQUENCE requestExtensions) {
        this.version = version != null ? version : v1;
        this.requestorName = requestorName;
        this.requestList = requestList;
        this.requestExtensions = requestExtensions;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream ostream) throws IOException {
        this.encode(TAG, ostream);
    }

    public void encode(Tag implicitTag, OutputStream ostream) throws IOException {
        SEQUENCE seq = new SEQUENCE();
        if (this.version != v1) {
            seq.addElement((ASN1Value)new EXPLICIT(Tag.get((long)0L), (ASN1Value)this.version));
        }
        if (this.requestorName != null) {
            seq.addElement((ASN1Value)new EXPLICIT(Tag.get((long)1L), (ASN1Value)this.requestorName));
        }
        seq.addElement((ASN1Value)this.requestList);
        if (this.requestExtensions != null) {
            seq.addElement((ASN1Value)new EXPLICIT(Tag.get((long)2L), (ASN1Value)this.requestExtensions));
        }
        if (implicitTag == null) {
            seq.encode(ostream);
        } else {
            seq.encode(implicitTag, ostream);
        }
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement((ASN1Template)new EXPLICIT.Template(new Tag(0L), (ASN1Template)new INTEGER.Template()), (ASN1Value)new EXPLICIT(new Tag(0L), (ASN1Value)new INTEGER(0L)));
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(1L), (ASN1Template)new ANY.Template()));
            this.seqt.addElement((ASN1Template)new SEQUENCE.OF_Template((ASN1Template)new Request.Template()));
            this.seqt.addOptionalElement((ASN1Template)new EXPLICIT.Template(new Tag(2L), (ASN1Template)new SEQUENCE.OF_Template((ASN1Template)new Extension.Template())));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals((Object)tag);
        }

        public ASN1Value decode(InputStream istream) throws InvalidBERException, IOException {
            return this.decode(TAG, istream);
        }

        public ASN1Value decode(Tag implicitTag, InputStream istream) throws InvalidBERException, IOException {
            EXPLICIT exts;
            SEQUENCE seq = (SEQUENCE)this.seqt.decode(implicitTag, istream);
            INTEGER v = v1;
            EXPLICIT e_ver = (EXPLICIT)seq.elementAt(0);
            if (e_ver != null) {
                v = (INTEGER)e_ver.getContent();
            }
            ANY requestorname = null;
            EXPLICIT e_requestorName = (EXPLICIT)seq.elementAt(1);
            if (e_requestorName != null) {
                requestorname = (ANY)e_requestorName.getContent();
            }
            SEQUENCE exts_seq = (exts = (EXPLICIT)seq.elementAt(3)) != null ? (SEQUENCE)exts.getContent() : null;
            return new TBSRequest(v, requestorname, (SEQUENCE)seq.elementAt(2), exts_seq);
        }
    }
}

