/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CAService;
import com.netscape.ca.IServant;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.cmscore.dbs.CRLRepository;
import com.netscape.cmscore.request.Request;
import java.security.cert.CRLException;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509ExtensionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceGetCRL
implements IServant {
    public static Logger logger = LoggerFactory.getLogger(ServiceGetCRL.class);

    public ServiceGetCRL(CAService service) {
    }

    @Override
    public boolean service(Request request) throws EBaseException {
        try {
            CAEngine engine = CAEngine.getInstance();
            CRLRepository crlRepository = engine.getCRLRepository();
            CRLIssuingPointRecord crlRec = crlRepository.readCRLIssuingPointRecord("MasterCRL");
            X509CRLImpl crl = new X509CRLImpl(crlRec.getCRL());
            request.setExtData("CRL", crl.getEncoded());
        }
        catch (EBaseException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_GETCRL_FIND_CRL", (Object[])new Object[0]), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_CRL_ISSUEPT_NOT_FOUND", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (CRLException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_GETCRL_INST_CRL", (Object[])new Object[]{"MasterCRL"}), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_CRL_ISSUEPT_NOGOOD", (String[])new String[]{"MasterCRL"}), (Throwable)e);
        }
        catch (X509ExtensionException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_GETCRL_NO_ISSUING_REC", (Object[])new Object[0]), (Throwable)e);
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_CRL_ISSUEPT_EXT_NOGOOD", (String[])new String[]{"MasterCRL"}), (Throwable)e);
        }
        return true;
    }
}

