/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import org.mozilla.jss.netscape.security.extensions.ExtendedKeyUsageExtension;
import org.mozilla.jss.netscape.security.util.ObjectIdentifier;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedKeyUsageExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(ExtendedKeyUsageExtDefault.class);
    public static final String CONFIG_CRITICAL = "exKeyUsageCritical";
    public static final String CONFIG_OIDS = "exKeyUsageOIDs";
    public static final String VAL_CRITICAL = "exKeyUsageCritical";
    public static final String VAL_OIDS = "exKeyUsageOIDs";

    public ExtendedKeyUsageExtDefault() {
        this.addValueName("exKeyUsageCritical");
        this.addValueName("exKeyUsageOIDs");
        this.addConfigName("exKeyUsageCritical");
        this.addConfigName("exKeyUsageOIDs");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("exKeyUsageCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("exKeyUsageOIDs")) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OIDS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("exKeyUsageCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals("exKeyUsageOIDs")) {
            return new Descriptor("string_list", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_OIDS", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        ExtendedKeyUsageExtension ext = null;
        ext = (ExtendedKeyUsageExtension)this.getExtension("2.5.29.37", info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals("exKeyUsageCritical")) {
            ext = (ExtendedKeyUsageExtension)this.getExtension("2.5.29.37", info);
            boolean val = Boolean.valueOf(value);
            if (ext == null) {
                return;
            }
            ext.setCritical(val);
        } else if (name.equals("exKeyUsageOIDs")) {
            ext = (ExtendedKeyUsageExtension)this.getExtension("2.5.29.37", info);
            StringTokenizer st = new StringTokenizer(value, ",");
            if (ext == null) {
                return;
            }
            while (st.hasMoreTokens()) {
                String oid = st.nextToken();
                ext.addOID(new ObjectIdentifier(oid));
            }
        } else {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        try {
            this.replaceExtension("2.5.29.37", (Extension)ext, info);
        }
        catch (EProfileException e) {
            logger.error("ExtendedKeyUsageExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        ExtendedKeyUsageExtension ext = (ExtendedKeyUsageExtension)this.getExtension("2.5.29.37", info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("exKeyUsageCritical")) {
            ext = (ExtendedKeyUsageExtension)this.getExtension("2.5.29.37", info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals("exKeyUsageOIDs")) {
            ext = (ExtendedKeyUsageExtension)this.getExtension("2.5.29.37", info);
            StringBuffer sb = new StringBuffer();
            if (ext == null) {
                return "";
            }
            Enumeration e = ext.getOIDs();
            while (e.hasMoreElements()) {
                ObjectIdentifier oid = (ObjectIdentifier)e.nextElement();
                if (!sb.toString().equals("")) {
                    sb.append(",");
                }
                sb.append(oid.toString());
            }
            return sb.toString();
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig("exKeyUsageCritical"), this.getConfig("exKeyUsageOIDs")};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_EXTENDED_KEY_EXT", (String[])params);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        ExtendedKeyUsageExtension ext = this.createExtension();
        this.addExtension("2.5.29.37", (Extension)ext, info);
    }

    public ExtendedKeyUsageExtension createExtension() {
        ExtendedKeyUsageExtension ext = null;
        try {
            ext = new ExtendedKeyUsageExtension();
        }
        catch (Exception e) {
            logger.warn("ExtendedKeyUsageExtDefault: createExtension " + e.getMessage(), (Throwable)e);
        }
        if (ext == null) {
            return null;
        }
        boolean critical = this.getBoolean(this.getConfig("exKeyUsageCritical"));
        ext.setCritical(critical);
        StringTokenizer st = new StringTokenizer(this.getConfig("exKeyUsageOIDs"), ",");
        while (st.hasMoreTokens()) {
            String oid = st.nextToken();
            ext.addOID(new ObjectIdentifier(oid));
        }
        return ext;
    }
}

