/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.profile;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.connector.ConnectorConfig;
import com.netscape.certsrv.connector.ConnectorsConfig;
import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.certsrv.template.ArgList;
import com.netscape.certsrv.template.ArgSet;
import com.netscape.cms.profile.common.Profile;
import com.netscape.cms.profile.common.ProfileInput;
import com.netscape.cms.profile.common.ProfilePolicy;
import com.netscape.cms.profile.constraint.PolicyConstraint;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.profile.ProfileServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.profile.ProfileSubsystem;
import com.netscape.cmscore.request.RequestQueue;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="caProfileSelect", urlPatterns={"/ee/ca/profileSelect"}, initParams={@WebInitParam(name="GetClientCert", value="false"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authorityId", value="ca"), @WebInitParam(name="interface", value="ee"), @WebInitParam(name="ID", value="caProfileSelect"), @WebInitParam(name="templatePath", value="/ee/ca/ProfileSelect.template"), @WebInitParam(name="resourceID", value="certServer.ee.profile")})
public class ProfileSelectServlet
extends ProfileServlet {
    public static Logger logger = LoggerFactory.getLogger(ProfileSelectServlet.class);
    private static final long serialVersionUID = -3765390650830903602L;
    private static final String PROP_AUTHORITY_ID = "authorityId";
    private String mAuthorityId = null;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mAuthorityId = sc.getInitParameter(PROP_AUTHORITY_ID);
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest request = cmsReq.getHttpReq();
        HttpServletResponse response = cmsReq.getHttpResp();
        logger.debug("ProfileSelectServlet: start serving");
        Locale locale = this.getLocale(request);
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        CAConfig caConfig = cs.getCAConfig();
        ConnectorsConfig connectorsConfig = caConfig.getConnectorsConfig();
        ConnectorConfig kraConnectorConfig = connectorsConfig.getConnectorConfig("KRA");
        AuthToken authToken = null;
        ArgSet args = new ArgSet();
        if (this.mAuthMgr != null) {
            try {
                authToken = this.authenticate(request);
            }
            catch (EBaseException e) {
                logger.error("ProcessReqServlet: " + e.getMessage(), (Throwable)e);
                logger.error(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}));
                args.set("errorCode", "1");
                args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHENTICATION_ERROR", (String[])new String[0]));
                this.outputTemplate(request, response, args);
                return;
            }
        }
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHORIZATION_ERROR", (String[])new String[0]));
            this.outputTemplate(request, response, args);
            return;
        }
        if (this.mProfileSubId == null || this.mProfileSubId.equals("")) {
            this.mProfileSubId = "profile";
        }
        logger.debug("ProfileSelectServlet: SubId=" + this.mProfileSubId);
        ProfileSubsystem ps = engine.getProfileSubsystem(this.mProfileSubId);
        if (ps == null) {
            logger.error("ProfileSelectServlet: ProfileSubsystem not found");
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
            this.outputTemplate(request, response, args);
            return;
        }
        IAuthority authority = (IAuthority)engine.getSubsystem(this.mAuthorityId);
        if (authority == null) {
            logger.error("ProfileSelectServlet: Authority " + this.mAuthorityId + " not found");
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
            this.outputTemplate(request, response, args);
            return;
        }
        RequestQueue queue = engine.getRequestQueue();
        if (queue == null) {
            logger.error("ProfileSelectServlet: Request Queue of " + this.mAuthorityId + " not found");
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_INTERNAL_ERROR", (String[])new String[0]));
            this.outputTemplate(request, response, args);
            return;
        }
        Profile profile = null;
        String profileId = request.getParameter("profileId");
        logger.debug("ProfileSelectServlet: profileId=" + profileId);
        try {
            profile = ps.getProfile(profileId);
        }
        catch (EProfileException e) {
            logger.error("ProfileSelectServlet: profile not found profileId=" + profileId + " " + e.getMessage(), (Throwable)e);
        }
        if (profile == null) {
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_NOT_FOUND", (String[])new String[]{CMSTemplate.escapeJavaScriptStringHTML((String)profileId)}));
            this.outputTemplate(request, response, args);
            return;
        }
        ArgList setlist = new ArgList();
        Enumeration<String> policySetIds = profile.getProfilePolicySetIds();
        if (policySetIds != null) {
            while (policySetIds.hasMoreElements()) {
                String setId = policySetIds.nextElement();
                ArgList list = new ArgList();
                Enumeration<String> policyIds = profile.getProfilePolicyIds(setId);
                if (policyIds != null) {
                    while (policyIds.hasMoreElements()) {
                        String id = policyIds.nextElement();
                        ProfilePolicy policy = profile.getProfilePolicy(setId, id);
                        this.handlePolicy(list, (ServletResponse)response, locale, id, policy);
                    }
                }
                ArgSet setArg = new ArgSet();
                setArg.set("setId", setId);
                setArg.set("policy", list);
                setlist.add(setArg);
            }
        }
        args.set("policySetList", setlist);
        args.set("profileId", profileId);
        args.set("profileIsEnable", Boolean.toString(ps.isProfileEnable(profileId)));
        args.set("profileEnableBy", ps.getProfileEnableBy(profileId));
        args.set("profileName", profile.getName(locale));
        args.set("profileDesc", profile.getDescription(locale));
        args.set("profileIsVisible", Boolean.toString(profile.isVisible()));
        args.set("errorCode", "0");
        args.set("errorReason", "");
        try {
            boolean keyArchivalEnabled = kraConnectorConfig.getBoolean("enable", false);
            if (keyArchivalEnabled) {
                logger.debug("ProfileSelectServlet: keyArchivalEnabled is true");
                args.set("transportCert", kraConnectorConfig.getString("transportCert", ""));
            } else {
                logger.debug("ProfileSelectServlet: keyArchivalEnabled is false");
                args.set("transportCert", "");
            }
        }
        catch (EBaseException e) {
            logger.warn("ProfileSelectServlet: exception caught:" + e.getMessage(), (Throwable)e);
        }
        ArgList authlist = new ArgList();
        AuthManager authenticator = null;
        try {
            authenticator = ps.getProfileAuthenticator(profile);
        }
        catch (EProfileException e) {
            args.set("errorCode", "1");
            args.set("errorReason", CMS.getUserMessage((Locale)locale, (String)"CMS_AUTHENTICATION_MANAGER_NOT_FOUND", (String[])new String[]{profile.getAuthenticatorId()}));
            this.outputTemplate(request, response, args);
            return;
        }
        if (authenticator != null) {
            Enumeration authNames = authenticator.getValueNames();
            if (authNames != null) {
                while (authNames.hasMoreElements()) {
                    ArgSet authset = new ArgSet();
                    String authName = (String)authNames.nextElement();
                    IDescriptor authDesc = authenticator.getValueDescriptor(locale, authName);
                    if (authDesc == null) continue;
                    String authSyntax = authDesc.getSyntax();
                    String authConstraint = authDesc.getConstraint();
                    String authValueName = authDesc.getDescription(locale);
                    authset.set("authId", authName);
                    authset.set("authSyntax", authSyntax);
                    authset.set("authConstraint", authConstraint);
                    authset.set("authName", authValueName);
                    authlist.add(authset);
                }
            }
            args.set("authList", authlist);
            args.set("authName", authenticator.getName(locale));
            args.set("authDesc", authenticator.getText(locale));
            args.set("authIsSSLClientRequired", Boolean.toString(authenticator.isSSLClientRequired()));
        }
        ArgList inputlist = new ArgList();
        ArgList inputPluginlist = new ArgList();
        Enumeration<String> inputIds = profile.getProfileInputIds();
        if (inputIds != null) {
            while (inputIds.hasMoreElements()) {
                String inputId = inputIds.nextElement();
                ProfileInput profileInput = profile.getProfileInput(inputId);
                if (profileInput == null) continue;
                ArgSet inputpluginset = new ArgSet();
                inputpluginset.set("inputPluginId", inputId);
                inputpluginset.set("inputPluginName", profileInput.getName(locale));
                inputpluginset.set("inputPluginDesc", profileInput.getText(locale));
                inputPluginlist.add(inputpluginset);
                Enumeration<String> inputNames = profileInput.getValueNames();
                if (inputNames == null) continue;
                while (inputNames.hasMoreElements()) {
                    ArgSet inputset = new ArgSet();
                    String inputName = inputNames.nextElement();
                    IDescriptor inputDesc = profileInput.getValueDescriptor(locale, inputName);
                    if (inputDesc == null) continue;
                    String inputSyntax = inputDesc.getSyntax();
                    String inputConstraint = inputDesc.getConstraint();
                    String inputValueName = inputDesc.getDescription(locale);
                    String inputValue = null;
                    inputset.set("inputPluginId", inputId);
                    inputset.set("inputId", inputName);
                    inputset.set("inputSyntax", inputSyntax);
                    inputset.set("inputConstraint", inputConstraint);
                    inputset.set("inputName", inputValueName);
                    inputset.set("inputVal", inputValue);
                    inputlist.add(inputset);
                }
            }
        }
        args.set("inputList", inputlist);
        args.set("inputPluginList", inputPluginlist);
        args.set("renewal", profile.isRenewal());
        args.set("xmlOutput", profile.isXmlOutput());
        this.outputTemplate(request, response, args);
    }

    private void handlePolicy(ArgList list, ServletResponse response, Locale locale, String id, ProfilePolicy policy) {
        ArgSet set = new ArgSet();
        set.set("policyId", id);
        PolicyDefault def = policy.getDefault();
        String dDesc = def.getText(locale);
        set.set("defDesc", dDesc);
        ArgList deflist = new ArgList();
        Enumeration<String> defNames = def.getValueNames();
        if (defNames != null) {
            while (defNames.hasMoreElements()) {
                ArgSet defset = new ArgSet();
                String defName = defNames.nextElement();
                IDescriptor defDesc = def.getValueDescriptor(locale, defName);
                if (defDesc == null) continue;
                String defSyntax = defDesc.getSyntax();
                String defConstraint = defDesc.getConstraint();
                String defValueName = defDesc.getDescription(locale);
                String defValue = null;
                defset.set("defId", defName);
                defset.set("defSyntax", defSyntax);
                defset.set("defConstraint", defConstraint);
                defset.set("defName", defValueName);
                defset.set("defVal", defValue);
                deflist.add(defset);
            }
        }
        set.set("defList", deflist);
        PolicyConstraint con = policy.getConstraint();
        String conDesc = con.getText(locale);
        set.set("conDesc", conDesc);
        ArgList conlist = new ArgList();
        Enumeration conNames = con.getConfigNames();
        if (conNames != null) {
            while (conNames.hasMoreElements()) {
                ArgSet conset = new ArgSet();
                String conName = (String)conNames.nextElement();
                conset.set("name", conName);
                conset.set("value", con.getConfig(conName));
                conlist.add(conset);
            }
        }
        set.set("constraint", conlist);
        list.add(set);
    }
}

