/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.ca.rest;

import com.netscape.certsrv.base.BadRequestException;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.system.CertificateSetupRequest;
import com.netscape.cms.servlet.base.PKIService;
import com.netscape.cmscore.apps.PreOpConfig;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.CertRequestRepository;
import java.math.BigInteger;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="installer")
public class CAInstallerService
extends PKIService {
    public static Logger logger = LoggerFactory.getLogger(CAInstallerService.class);

    public void validatePin(String pin) throws Exception {
        if (pin == null) {
            throw new BadRequestException("Missing configuration PIN");
        }
        CAEngine engine = (CAEngine)this.getCMSEngine();
        CAEngineConfig cs = engine.getConfig();
        PreOpConfig preopConfig = cs.getPreOpConfig();
        String preopPin = preopConfig.getString("pin");
        if (!preopPin.equals(pin)) {
            throw new BadRequestException("Invalid configuration PIN");
        }
    }

    @POST
    @Path(value="createRequestID")
    public RequestId createRequestID(CertificateSetupRequest request) throws Exception {
        logger.info("CAInstallerService: Creating request ID");
        try {
            this.validatePin(request.getPin());
            CAEngine engine = (CAEngine)this.getCMSEngine();
            CAEngineConfig cs = engine.getConfig();
            String csState = "" + cs.getState();
            if (csState.equals("1")) {
                throw new BadRequestException("System already configured");
            }
            CertRequestRepository requestRepository = engine.getCertRequestRepository();
            RequestId requestID = requestRepository.createRequestID();
            logger.info("CAInstallerService: - request ID: " + requestID.toHexString());
            return requestID;
        }
        catch (Throwable e) {
            logger.error("Unable to create request ID: " + e.getMessage(), e);
            throw e;
        }
    }

    @POST
    @Path(value="createCertID")
    public CertId createCertID(CertificateSetupRequest request) throws Exception {
        logger.info("CAInstallerService: Creating cert ID");
        try {
            this.validatePin(request.getPin());
            CAEngine engine = (CAEngine)this.getCMSEngine();
            CAEngineConfig cs = engine.getConfig();
            String csState = "" + cs.getState();
            if (csState.equals("1")) {
                throw new BadRequestException("System already configured");
            }
            CertificateRepository certificateRepository = engine.getCertificateRepository();
            BigInteger serialNumber = certificateRepository.getNextSerialNumber();
            CertId certID = new CertId(serialNumber);
            logger.info("CAInstallerService: - cert ID: " + certID.toHexString());
            return certID;
        }
        catch (Throwable e) {
            logger.error("Unable to create cert ID: " + e.getMessage(), e);
            throw e;
        }
    }
}

