/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.key;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.key.KeyRecordParser;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.kra.KeyRecoveryAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Hashtable;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;

@WebServlet(name="kraKRAExamineRecovery", urlPatterns={"/agent/kra/examineRecovery"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="kra"), @WebInitParam(name="interface", value="agent"), @WebInitParam(name="templatePath", value="/agent/kra/examineRecovery.template"), @WebInitParam(name="ID", value="kraKRAExamineRecovery"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr"), @WebInitParam(name="resourceID", value="certServer.kra.key")})
public class ExamineRecovery
extends CMSServlet {
    private static final long serialVersionUID = -953282265332774966L;
    private static final String INFO = "examineRecovery";
    private static final String TPL_FILE = "examineRecovery.template";
    private static final String OUT_OP = "op";
    private static final String OUT_SERVICE_URL = "serviceURL";
    private KeyRecoveryAuthority mService;
    private String mFormPath = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        KRAEngine engine = KRAEngine.getInstance();
        this.mService = engine.getKRA();
        this.mFormPath = "/kra/examineRecovery.template";
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    public String getServletInfo() {
        return INFO;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        EBaseException error = null;
        try {
            this.process(header, req.getParameter("recoveryID"), req);
        }
        catch (EBaseException e) {
            error = e;
        }
        catch (Exception e) {
            error = new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
        }
        try {
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    ServletOutputStream out = resp.getOutputStream();
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError(error);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    private void process(ArgBlock header, String recoveryID, HttpServletRequest req) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        KRAEngineConfig cs = engine.getConfig();
        try {
            header.addStringValue(OUT_OP, req.getParameter(OUT_OP));
            header.addStringValue(OUT_SERVICE_URL, req.getRequestURI());
            header.addStringValue("keySplitting", cs.getString("kra.keySplitting"));
            Hashtable<String, Object> params = this.mService.getRecoveryParams(recoveryID);
            if (params == null) {
                logger.error(CMS.getLogMessage((String)"CMSGW_NO_RECOVERY_TOKEN_FOUND_1", (Object[])new Object[]{recoveryID}));
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_NO_RECOVERY_TOKEN_FOUND", (String[])new String[]{recoveryID}));
            }
            String keyID = (String)params.get("keyID");
            header.addStringValue("serialNumber", keyID);
            header.addStringValue("recoveryID", recoveryID);
            KeyRepository mKeyDB = this.mService.getKeyRepository();
            KeyRecord rec = mKeyDB.readKeyRecord(new BigInteger(keyID));
            KeyRecordParser.fillRecordIntoArg((KeyRecord)rec, (ArgBlock)header);
        }
        catch (EBaseException e) {
            logger.error("ExamineRecovery: " + e.getMessage(), (Throwable)e);
            throw e;
        }
    }
}

