/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.key;

import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.SecurityDataExportEvent;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.kra.KeyRecoveryAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.kra.KRAEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetAsyncPk12
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(GetAsyncPk12.class);
    private static final long serialVersionUID = 6933634840339605800L;
    private static final String INFO = "getAsyncPk12";
    private static final String TPL_FILE = "finishAsyncRecovery.template";
    private static final String IN_PASSWORD = "p12Password";
    private static final String IN_PASSWORD_AGAIN = "p12PasswordAgain";
    private static final String OUT_ERROR = "errorDetails";
    private KeyRecoveryAuthority mService;
    private String mFormPath = null;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/agent/kra/finishAsyncRecovery.template";
        KRAEngine engine = KRAEngine.getInstance();
        this.mService = engine.getKRA();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    public String getServletInfo() {
        return INFO;
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        Object auditMessage = null;
        String agent = null;
        String reqID = null;
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "download");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
        ArgBlock header = new ArgBlock();
        ArgBlock fixed = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, fixed);
        try {
            reqID = req.getParameter("reqID");
            header.addStringValue("reqID", reqID);
            SessionContext sContext = SessionContext.getContext();
            if (sContext != null) {
                agent = (String)sContext.get((Object)"userid");
            }
            if (agent == null) {
                logger.error("GetAsyncPk12::process() - agent is null!");
                throw new EBaseException("agent is null");
            }
            String initAgent = "undefined";
            initAgent = this.mService.getInitAgentAsyncKeyRecovery(reqID);
            if (initAgent.equals("undefined") || !agent.equals(initAgent)) {
                logger.error(CMS.getLogMessage((String)"CMSGW_INVALID_AGENT_ASYNC_3", (Object[])new Object[]{reqID, initAgent}));
                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_INVALID_AGENT_ASYNC", (String[])new String[]{reqID, initAgent}));
            }
            if (!this.mService.isApprovedAsyncKeyRecovery(reqID)) {
                logger.error("GetAsyncPk12::process() - # required recovery agents not met");
                throw new EBaseException("# required recovery agents not met");
            }
            String password = req.getParameter(IN_PASSWORD);
            String passwordAgain = req.getParameter(IN_PASSWORD_AGAIN);
            if (password == null || password.equals("")) {
                header.addStringValue(OUT_ERROR, "PKCS12 password not found");
                throw new EBaseException("PKCS12 password not found");
            }
            if (passwordAgain == null || !passwordAgain.equals(password)) {
                header.addStringValue(OUT_ERROR, "PKCS12 password not matched");
                throw new EBaseException("PKCS12 password not matched");
            }
            byte[] pkcs12 = this.mService.doKeyRecovery(reqID, password);
            if (pkcs12 != null) {
                try {
                    resp.setContentType("application/x-pkcs12");
                    resp.getOutputStream().write(pkcs12);
                    this.mRenderResult = false;
                    auditor.log((LogEvent)new SecurityDataExportEvent(agent, "Success", new RequestId(reqID), null, null, null));
                    return;
                }
                catch (IOException e) {
                    header.addStringValue(OUT_ERROR, CMS.getUserMessage((Locale)locale[0], (String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{e.toString()}));
                }
            } else if (this.mService.getError(reqID) != null) {
                header.addStringValue(OUT_ERROR, this.mService.getError(reqID));
            }
        }
        catch (EBaseException e) {
            header.addStringValue(OUT_ERROR, e.toString(locale[0]));
        }
        if (agent != null && reqID != null) {
            auditor.log((LogEvent)new SecurityDataExportEvent(agent, "Failure", new RequestId(reqID), null, null, null));
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            resp.setContentType("text/html");
            form.renderOutput((OutputStream)out, argSet);
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        cmsReq.setStatus(CMSRequest.SUCCESS);
    }
}

