/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.kra;

import com.netscape.certsrv.authority.IAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.EPropertyNotFound;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.dbs.keydb.KeyId;
import com.netscape.certsrv.listeners.EListenersException;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.SecurityDataArchivalProcessedEvent;
import com.netscape.certsrv.logging.event.SecurityDataArchivalRequestEvent;
import com.netscape.certsrv.logging.event.SecurityDataRecoveryEvent;
import com.netscape.certsrv.logging.event.SecurityDataRecoveryProcessedEvent;
import com.netscape.certsrv.request.IPolicy;
import com.netscape.certsrv.request.IService;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.certsrv.security.Credential;
import com.netscape.certsrv.security.IStorageKeyUnit;
import com.netscape.cms.request.RequestScheduler;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.dbs.DBSubsystem;
import com.netscape.cmscore.dbs.KeyRecord;
import com.netscape.cmscore.dbs.KeyRepository;
import com.netscape.cmscore.dbs.KeyStatusUpdateTask;
import com.netscape.cmscore.dbs.ReplicaIDRepository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.KeyRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestNotifier;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.request.RequestRepository;
import com.netscape.cmscore.request.RequestSubsystem;
import com.netscape.cmscore.security.JssSubsystem;
import com.netscape.cmscore.usrgrp.UGSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.kra.KRANotify;
import com.netscape.kra.KRAService;
import com.netscape.kra.SecurityDataProcessor;
import com.netscape.kra.StorageKeyUnit;
import com.netscape.kra.TransportKeyUnit;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.dogtagpki.legacy.kra.KRAPolicy;
import org.dogtagpki.legacy.kra.KRAPolicyConfig;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.server.kra.KRAConfig;
import org.dogtagpki.server.kra.KRAEngine;
import org.dogtagpki.server.kra.KRAEngineConfig;
import org.mozilla.jss.NoSuchTokenException;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.KeyPairGeneratorSpi;
import org.mozilla.jss.crypto.PQGParamGenException;
import org.mozilla.jss.crypto.PQGParams;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.DerOutputStream;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyRecoveryAuthority
extends Subsystem
implements IAuthority {
    public static Logger logger = LoggerFactory.getLogger(KeyRecoveryAuthority.class);
    public static final String ID = "kra";
    public static final String OFFICIAL_NAME = "Data Recovery Manager";
    public static final String PROP_NAME = "name";
    public static final String PROP_HTTP = "http";
    public static final String PROP_POLICY = "policy";
    public static final String PROP_TOKEN = "token";
    public static final String PROP_SHARE = "share";
    public static final String PROP_PROTECTOR = "protector";
    public static final String PROP_LOGGING = "logging";
    public static final String PROP_QUEUE_REQUESTS = "queueRequests";
    public static final String PROP_STORAGE_KEY = "storageUnit";
    public static final String PROP_TRANSPORT_KEY = "transportUnit";
    public static final String PROP_NEW_NICKNAME = "newNickname";
    public static final String PROP_KEYDB_INC = "keydbInc";
    public static final String PROP_NOTIFY_SUBSTORE = "notification";
    public static final String PROP_REQ_IN_Q_SUBSTORE = "requestInQ";
    private static final String PARAM_CREDS = "creds";
    private static final String PARAM_LOCK = "lock";
    private static final String PARAM_PK12 = "pk12";
    private static final String PARAM_ERROR = "error";
    protected boolean mInitialized = false;
    protected KRAConfig mConfig;
    protected KRAPolicy mPolicy = null;
    protected X500Name mName = null;
    protected boolean mQueueRequests = false;
    protected String mId = null;
    protected TransportKeyUnit mTransportKeyUnit;
    protected StorageKeyUnit mStorageKeyUnit = null;
    protected Hashtable<String, Credential[]> mAutoRecovery = new Hashtable();
    protected boolean mAutoRecoveryOn = false;
    protected KeyRepository mKeyDB = null;
    protected ReplicaIDRepository mReplicaRepot = null;
    protected int mRecoveryIDCounter = 0;
    protected Hashtable<String, Hashtable<String, Object>> mRecoveryParams = new Hashtable();
    protected X509Certificate mJssCert = null;
    protected CryptoToken mKeygenToken = null;
    private int mEntropyBitsPerKeyPair = 0;
    private int mEntropyBlockWarnMilliseconds = 0;
    public RequestListener mReqInQListener = null;
    public KeyStatusUpdateTask keyStatusUpdateTask;
    private static final String SIGNED_AUDIT_AGENT_DELIMITER = ", ";
    public Hashtable<String, Hashtable<String, Object>> mVolatileRequests = new Hashtable();

    public String getId() {
        return this.mId;
    }

    public void setId(String id) throws EBaseException {
        this.mId = id;
    }

    public IPolicyProcessor getPolicyProcessor() {
        return this.mPolicy.getPolicyProcessor();
    }

    private void initEntropy(ConfigStore config) {
        this.mEntropyBitsPerKeyPair = 0;
        this.mEntropyBlockWarnMilliseconds = 50;
        ConfigStore ecs = config.getSubStore("entropy", ConfigStore.class);
        if (ecs != null) {
            try {
                this.mEntropyBitsPerKeyPair = ecs.getInteger("bitsperkeypair", 0);
                this.mEntropyBlockWarnMilliseconds = ecs.getInteger("blockwarnms", 50);
            }
            catch (EBaseException eBaseException) {
                // empty catch block
            }
        }
        logger.debug("KeyRecoveryAuthority Entropy bits = " + this.mEntropyBitsPerKeyPair);
        if (this.mEntropyBitsPerKeyPair != 0) {
            logger.debug("KeyRecoveryAuthority about to add Entropy");
            this.addEntropy(false);
            logger.debug("KeyRecoveryAuthority back from add Entropy");
        }
    }

    public void addEntropy(boolean logflag) {
        long start;
        block5: {
            logger.debug("KeyRecoveryAuthority addEntropy()");
            if (this.mEntropyBitsPerKeyPair == 0) {
                logger.debug("KeyRecoveryAuthority returning - disabled()");
                return;
            }
            start = System.currentTimeMillis();
            try {
                JssSubsystem jssSubsystem = this.engine.getJSSSubsystem();
                jssSubsystem.addEntropy(this.mEntropyBitsPerKeyPair);
            }
            catch (Exception e) {
                logger.warn("KeyRecoveryAuthority: " + e.getMessage(), (Throwable)e);
                if (!logflag) break block5;
                logger.warn(CMS.getLogMessage((String)"CMSCORE_KRA_ENTROPY_ERROR", (Object[])new Object[]{e.getMessage()}));
            }
        }
        long end = System.currentTimeMillis();
        long duration = end - start;
        if (this.mEntropyBlockWarnMilliseconds > 0 && duration > (long)this.mEntropyBlockWarnMilliseconds) {
            logger.debug("KeyRecoveryAuthority returning - warning - entropy took too long (ms=" + duration + ")");
            if (logflag) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_KRA_ENTROPY_BLOCKED_WARNING", (Object[])new Object[]{"" + (int)duration}));
            }
        }
        logger.debug("KeyRecoveryAuthority returning ");
    }

    public void startKeyStatusUpdate() throws EBaseException {
        logger.info("KeyRecoveryAuthority: Key status update task:");
        KRAEngine engine = KRAEngine.getInstance();
        DBSubsystem dbSubsystem = engine.getDBSubsystem();
        int interval = this.mConfig.getInteger("keyStatusUpdateInterval", 600);
        logger.info("KeyRecoveryAuthority: - interval: " + interval);
        if (this.keyStatusUpdateTask != null) {
            this.keyStatusUpdateTask.stop();
        }
        if (interval == 0 || !dbSubsystem.getEnableSerialMgmt()) {
            logger.info("KeyRecoveryAuthority: Key status update task is disabled");
            return;
        }
        logger.info("KeyRecoveryAuthority: Starting key status update task");
        KeyRequestRepository requestRepository = engine.getKeyRequestRepository();
        this.keyStatusUpdateTask = new KeyStatusUpdateTask(this.mKeyDB, requestRepository, interval);
        this.keyStatusUpdateTask.start();
    }

    public void init(ConfigStore config) throws Exception {
        logger.debug("KeyRecoveryAuthority init() begins");
        if (this.mInitialized) {
            return;
        }
        KRAEngine kraEngine = (KRAEngine)this.engine;
        KRAEngineConfig engineConfig = kraEngine.getConfig();
        DBSubsystem dbSubsystem = this.engine.getDBSubsystem();
        this.mConfig = engineConfig.getKRAConfig();
        KRAPolicyConfig kraPolicyConfig = this.mConfig.getPolicyConfig();
        this.mPolicy = new KRAPolicy();
        this.mPolicy.init(this, kraPolicyConfig);
        int keydb_inc = this.mConfig.getInteger(PROP_KEYDB_INC, 5);
        JssSubsystem jssSubsystem = this.engine.getJSSSubsystem();
        SecureRandom secureRandom = jssSubsystem.getRandomNumberGenerator();
        this.mKeyDB = new KeyRepository(secureRandom, dbSubsystem);
        this.mKeyDB.setCMSEngine(this.engine);
        this.mKeyDB.init();
        this.mTransportKeyUnit = new TransportKeyUnit();
        try {
            this.mTransportKeyUnit.init(this.mConfig.getSubStore(PROP_TRANSPORT_KEY, ConfigStore.class));
        }
        catch (Exception e) {
            logger.warn("KeyRecoveryAuthority: transport unit exception " + e.getMessage(), (Throwable)e);
            return;
        }
        try {
            this.mJssCert = this.mTransportKeyUnit.getCertificate();
            X509CertImpl certImpl = new X509CertImpl(this.mJssCert.getEncoded());
            this.mName = certImpl.getSubjectName();
        }
        catch (CertificateEncodingException e) {
            logger.error("KeyRecoveryAuthority: " + e.getMessage(), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_LOAD_FAILED", (String[])new String[]{"transport cert " + e.toString()}));
        }
        catch (CertificateException e) {
            logger.error("KeyRecoveryAuthority: " + e.getMessage(), (Throwable)e);
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_LOAD_FAILED", (String[])new String[]{"transport cert " + e.toString()}));
        }
        this.mStorageKeyUnit = new StorageKeyUnit();
        try {
            this.mStorageKeyUnit.init(this.mConfig.getSubStore(PROP_STORAGE_KEY, ConfigStore.class), this.mConfig.getBoolean("keySplitting", false));
        }
        catch (EBaseException e) {
            logger.error("KeyRecoveryAuthority: storage unit exception " + e.getMessage(), (Throwable)e);
            throw e;
        }
        String serverKeygenTokenName = this.mConfig.getString("serverKeygenTokenName", null);
        if (serverKeygenTokenName == null) {
            logger.debug("serverKeygenTokenName set to nothing");
            if (this.mStorageKeyUnit.getToken() != null) {
                try {
                    String storageToken = this.mStorageKeyUnit.getToken().getName();
                    if (!CryptoUtil.isInternalToken((String)storageToken)) {
                        logger.debug("Auto set serverKeygenTokenName to " + storageToken);
                        serverKeygenTokenName = storageToken;
                    }
                }
                catch (Exception storageToken) {
                    // empty catch block
                }
            }
        }
        if (serverKeygenTokenName == null) {
            serverKeygenTokenName = "internal";
        }
        if (CryptoUtil.isInternalToken((String)serverKeygenTokenName)) {
            serverKeygenTokenName = "internal";
        }
        try {
            this.mKeygenToken = CryptoUtil.getKeyStorageToken((String)serverKeygenTokenName);
            logger.debug("KeyRecoveryAuthority: token: " + this.mKeygenToken.getName());
            logger.debug("KeyRecoveryAuthority: set up keygenToken");
        }
        catch (NoSuchTokenException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_TOKEN_NOT_FOUND", (String[])new String[]{serverKeygenTokenName}));
        }
        catch (Exception e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_CRYPTOMANAGER_UNINITIALIZED", (String[])new String[0]));
        }
        logger.debug("KeyRecoveryAuthority: about to init entropy");
        this.initEntropy(this.mConfig);
        logger.debug("KeyRecoveryAuthority: completed init of entropy");
        logger.info(this.mName.toString() + " is started");
        KRAService service = new KRAService(this);
        KRANotify requestNotifier = new KRANotify();
        requestNotifier.setCMSEngine(this.engine);
        this.engine.setRequestNotifier((RequestNotifier)requestNotifier);
        RequestNotifier pendingNotifier = new RequestNotifier();
        pendingNotifier.setCMSEngine(this.engine);
        this.engine.setPendingNotifier(pendingNotifier);
        RequestSubsystem reqSub = this.engine.getRequestSubsystem();
        int reqdb_inc = this.mConfig.getInteger("reqdbInc", 5);
        KeyRequestRepository requestRepository = new KeyRequestRepository(secureRandom, dbSubsystem);
        requestRepository.setCMSEngine(this.engine);
        requestRepository.init();
        this.engine.setRequestRepository((RequestRepository)requestRepository);
        RequestQueue requestQueue = new RequestQueue(dbSubsystem, (RequestRepository)requestRepository, (IPolicy)this.mPolicy, (IService)service, (RequestNotifier)requestNotifier, pendingNotifier);
        this.engine.setRequestQueue(requestQueue);
        this.startKeyStatusUpdate();
        String schedulerClass = this.mConfig.getString("requestSchedulerClass", null);
        if (schedulerClass != null) {
            try {
                RequestScheduler scheduler = (RequestScheduler)Class.forName(schedulerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                requestQueue.setRequestScheduler(scheduler);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.initNotificationListeners();
        this.mReplicaRepot = new ReplicaIDRepository(dbSubsystem);
        this.mReplicaRepot.setCMSEngine(this.engine);
        this.mReplicaRepot.init();
        logger.debug("Replica Repot inited");
    }

    public CryptoToken getKeygenToken() {
        return this.mKeygenToken;
    }

    public RequestListener getRequestInQListener() {
        return this.mReqInQListener;
    }

    public X509Certificate getTransportCert() {
        return this.mJssCert;
    }

    protected void finalize() {
        this.shutdown();
    }

    public void startup() throws EBaseException {
        logger.debug("KeyRecoveryAuthority startup() begins");
        KRAEngine engine = KRAEngine.getInstance();
        RequestQueue requestQueue = engine.getRequestQueue();
        if (requestQueue != null) {
            engine.recoverRequestQueue();
            logger.debug("KeyRecoveryAuthority startup() call request Q recover");
            this.mInitialized = true;
        } else {
            logger.warn("KeyRecoveryAuthority: mRequestQueue is null, could be in preop mode");
        }
    }

    public void shutdown() {
        if (!this.mInitialized) {
            return;
        }
        if (this.mStorageKeyUnit != null) {
            this.mStorageKeyUnit.shutdown();
        }
        if (this.keyStatusUpdateTask != null) {
            this.keyStatusUpdateTask.stop();
        }
        if (this.mKeyDB != null) {
            this.mKeyDB.shutdown();
        }
        logger.info(this.mName + " is stopped");
        this.mInitialized = false;
    }

    public KRAConfig getConfigStore() {
        return this.mConfig;
    }

    public boolean setAutoRecoveryState(Credential[] cs, boolean on) {
        if (on) {
            try {
                this.getStorageKeyUnit().login(cs);
            }
            catch (Exception e) {
                return false;
            }
        }
        this.mAutoRecoveryOn = on;
        return true;
    }

    public boolean getAutoRecoveryState() {
        return this.mAutoRecoveryOn;
    }

    public Enumeration<String> getAutoRecoveryIDs() {
        return this.mAutoRecovery.keys();
    }

    public void addAutoRecovery(String id, Credential[] creds) {
        this.mAutoRecovery.put(id, creds);
    }

    public void removeAutoRecovery(String id) {
        this.mAutoRecovery.remove(id);
    }

    public int getNoOfRequiredAgents() throws EBaseException {
        if (this.mConfig.getBoolean("keySplitting", false)) {
            return this.mStorageKeyUnit.getNoOfRequiredAgents();
        }
        int ret = -1;
        ret = this.mConfig.getInteger("noOfRequiredRecoveryAgents", 1);
        if (ret <= 0) {
            throw new EBaseException("Invalid parameter noOfRequiredRecoveryAgents");
        }
        return ret;
    }

    public int getNoOfRequiredSecurityDataRecoveryAgents() throws EBaseException {
        int ret = -1;
        ret = this.mConfig.getInteger("noOfRequiredSecurityDataRecoveryAgents", 1);
        if (ret <= 0) {
            throw new EBaseException("Invalid parameter noOfRequiredSecurityDataRecoveryAgents");
        }
        return ret;
    }

    public void setNoOfRequiredAgents(int number) throws EBaseException {
        if (this.mConfig.getBoolean("keySplitting")) {
            this.mStorageKeyUnit.setNoOfRequiredAgents(number);
        } else {
            this.mConfig.putInteger("noOfRequiredRecoveryAgents", number);
        }
    }

    public String getRecoveryID() {
        return Integer.toString(this.mRecoveryIDCounter++);
    }

    public Hashtable<String, Object> createRecoveryParams(String recoveryID) throws EBaseException {
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        h.put(PARAM_CREDS, new Vector());
        h.put(PARAM_LOCK, new Object());
        this.mRecoveryParams.put(recoveryID, h);
        return h;
    }

    public void destroyRecoveryParams(String recoveryID) throws EBaseException {
        this.mRecoveryParams.remove(recoveryID);
    }

    public Hashtable<String, Object> getRecoveryParams(String recoveryID) throws EBaseException {
        return this.mRecoveryParams.get(recoveryID);
    }

    public void createPk12(String recoveryID, byte[] pk12) throws EBaseException {
        Hashtable<String, Object> h = this.getRecoveryParams(recoveryID);
        h.put(PARAM_PK12, pk12);
    }

    public byte[] getPk12(String recoveryID) throws EBaseException {
        return (byte[])this.getRecoveryParams(recoveryID).get(PARAM_PK12);
    }

    public void createError(String recoveryID, String error) throws EBaseException {
        Hashtable<String, Object> h = this.getRecoveryParams(recoveryID);
        h.put(PARAM_ERROR, error);
    }

    public String getError(String recoveryID) throws EBaseException {
        return (String)this.getRecoveryParams(recoveryID).get(PARAM_ERROR);
    }

    public Vector<Credential> getAppAgents(String recoveryID) throws EBaseException {
        Hashtable<String, Object> h = this.getRecoveryParams(recoveryID);
        Vector dc = (Vector)h.get(PARAM_CREDS);
        return dc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential[] getDistributedCredentials(String recoveryID) throws EBaseException {
        Object lock;
        Hashtable<String, Object> h = this.getRecoveryParams(recoveryID);
        Vector dc = (Vector)h.get(PARAM_CREDS);
        Object object = lock = h.get(PARAM_LOCK);
        synchronized (object) {
            while (dc.size() < this.getNoOfRequiredAgents()) {
                logger.debug("KeyRecoveryAuthority: cfu in synchronized lock for getDistributedCredentials");
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            Object[] creds = new Credential[dc.size()];
            dc.copyInto(creds);
            return creds;
        }
    }

    private void verifyCredential(Vector<Credential> creds, String uid, String pwd) throws EBaseException {
        UGSubsystem ug;
        KRAEngine engine = KRAEngine.getInstance();
        if (!this.mConfig.getBoolean("keySplitting") && !(ug = engine.getUGSubsystem()).isMemberOf(uid, this.mConfig.getString("recoveryAgentGroup"))) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_CREDENTIALS_NOT_EXIST", (String[])new String[0]));
        }
        for (int i = 0; i < creds.size(); ++i) {
            Credential c = creds.elementAt(i);
            if (!c.getIdentifier().equals(uid)) continue;
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_CREDENTIALS_EXIST", (String[])new String[0]));
        }
        if (this.mConfig.getBoolean("keySplitting")) {
            this.mStorageKeyUnit.checkPassword(uid, pwd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDistributedCredential(String recoveryID, String uid, String pwd) throws EBaseException {
        Object lock;
        Hashtable<String, Object> h = this.getRecoveryParams(recoveryID);
        Vector dc = (Vector)h.get(PARAM_CREDS);
        Object object = lock = h.get(PARAM_LOCK);
        synchronized (object) {
            this.verifyCredential(dc, uid, pwd);
            dc.addElement(new Credential(uid, pwd));
            lock.notify();
        }
    }

    public Request archiveKey(KeyRecord rec) throws EBaseException {
        Auditor auditor = this.engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        String auditRequesterID = this.auditRequesterID();
        String auditPublicKey = this.auditPublicKey(rec);
        KRAEngine kraEngine = KRAEngine.getInstance();
        KeyRequestRepository requestRepository = kraEngine.getKeyRequestRepository();
        Request r = null;
        try {
            r = requestRepository.createRequest("enrollment");
            auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)r.getRequestId(), null));
        }
        catch (EBaseException eAudit1) {
            auditor.log((LogEvent)SecurityDataArchivalRequestEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, null, null, (Exception)((Object)eAudit1)));
            throw eAudit1;
        }
        try {
            if (r != null) {
                r.setExtData("keyRecord", rec.getSerialNumber());
                RequestQueue queue = this.engine.getRequestQueue();
                queue.processRequest(r);
            }
            auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createSuccessEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)r.getRequestId(), null, (KeyId)new KeyId(rec.getSerialNumber()), (String)auditPublicKey));
        }
        catch (EBaseException eAudit1) {
            auditor.log((LogEvent)SecurityDataArchivalProcessedEvent.createFailureEvent((String)auditSubjectID, (String)auditRequesterID, (RequestId)r.getRequestId(), null, (KeyId)new KeyId(rec.getSerialNumber()), (String)eAudit1.getMessage(), (String)auditPublicKey));
            throw eAudit1;
        }
        return r;
    }

    public String initAsyncKeyRecovery(BigInteger kid, X509CertImpl cert, String agent, String realm) throws EBaseException {
        Auditor auditor = this.engine.getAuditor();
        String auditPublicKey = this.auditPublicKey((java.security.cert.X509Certificate)cert);
        RequestId auditRecoveryID = null;
        String auditSubjectID = this.auditSubjectID();
        KRAEngine kraEngine = KRAEngine.getInstance();
        KeyRequestRepository requestRepository = kraEngine.getKeyRequestRepository();
        Request r = null;
        try {
            r = requestRepository.createRequest("recovery");
            r.setExtData("serialNumber", kid);
            r.setExtData("cert", cert);
            r.setExtData("approvingAgents", agent);
            r.setRequestStatus(RequestStatus.PENDING);
            r.setRealm(realm);
            requestRepository.updateRequest(r);
            auditRecoveryID = r.getRequestId();
            auditor.log((LogEvent)new SecurityDataRecoveryEvent(auditSubjectID, "Success", auditRecoveryID, null, auditPublicKey));
        }
        catch (EBaseException eAudit1) {
            auditor.log((LogEvent)new SecurityDataRecoveryEvent(auditSubjectID, "Failure", auditRecoveryID, null, auditPublicKey));
            throw eAudit1;
        }
        return r.getRequestId().toString();
    }

    public boolean isApprovedAsyncKeyRecovery(String reqID) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        RequestRepository requestRepository = engine.getRequestRepository();
        Request r = requestRepository.readRequest(new RequestId(reqID));
        return r.getRequestStatus() == RequestStatus.APPROVED;
    }

    public String getInitAgentAsyncKeyRecovery(String reqID) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        RequestRepository requestRepository = engine.getRequestRepository();
        Request r = requestRepository.readRequest(new RequestId(reqID));
        String agents = r.getExtDataInString("approvingAgents");
        if (agents != null) {
            int i = agents.indexOf(",");
            if (i == -1) {
                return agents;
            }
            return agents.substring(0, i);
        }
        logger.debug("getInitAgentAsyncKeyRecovery: no approvingAgents in request");
        return null;
    }

    public void addAgentAsyncKeyRecovery(String reqID, String agentID) throws EBaseException {
        UGSubsystem ug = this.engine.getUGSubsystem();
        if (!ug.isMemberOf(agentID, this.mConfig.getString("recoveryAgentGroup"))) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_CREDENTIALS_NOT_EXIST", (String[])new String[0]));
        }
        RequestRepository requestRepository = this.engine.getRequestRepository();
        Request r = requestRepository.readRequest(new RequestId(reqID));
        String agents = r.getExtDataInString("approvingAgents");
        if (agents != null) {
            int agentsRequired;
            int count = 0;
            StringTokenizer st = new StringTokenizer(agents, ",");
            while (st.hasMoreTokens()) {
                String a = st.nextToken();
                if (count != 0 && a.equals(agentID)) {
                    throw new EBaseException(CMS.getUserMessage((String)"CMS_KRA_CREDENTIALS_EXIST", (String[])new String[0]));
                }
                ++count;
            }
            int n = agentsRequired = r.getRequestType().equals("securityDataRecovery") ? this.getNoOfRequiredSecurityDataRecoveryAgents() : this.getNoOfRequiredAgents();
            if (count <= agentsRequired) {
                r.setExtData("approvingAgents", agents + "," + agentID);
                if (count == agentsRequired) {
                    r.setRequestStatus(RequestStatus.APPROVED);
                } else {
                    r.setRequestStatus(RequestStatus.PENDING);
                }
                requestRepository.updateRequest(r);
            }
        } else {
            logger.debug("addAgentAsyncKeyRecovery: no approvingAgents in request. Async recovery request not initiated?");
        }
    }

    public byte[] doKeyRecovery(BigInteger kid, Credential[] creds, String password, X509CertImpl cert, String delivery, String nickname, String agent) throws EBaseException {
        Auditor auditor = this.engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        RequestId auditRecoveryID = this.auditRecoveryID();
        String auditPublicKey = this.auditPublicKey((java.security.cert.X509Certificate)cert);
        String auditAgents = "<null>";
        KRAEngine kraEngine = KRAEngine.getInstance();
        KeyRequestRepository requestRepository = kraEngine.getKeyRequestRepository();
        Request r = null;
        Hashtable<String, Object> params = null;
        logger.debug("KeyRecoveryAuthority: in synchronous doKeyRecovery()");
        try {
            r = requestRepository.createRequest("recovery");
            params = this.createVolatileRequest(r.getRequestId());
            if (this.mConfig.getBoolean("keySplitting")) {
                params.put("agentCredentials", creds);
            }
            params.put("transportPwd", password);
            r.setExtData("serialNumber", kid);
            r.setExtData("cert", cert);
            if (nickname != null && !(nickname = nickname.trim()).equals("")) {
                r.setExtData("nickname", nickname);
            }
            r.setExtData("approvingAgents", agent);
            auditor.log((LogEvent)new SecurityDataRecoveryEvent(auditSubjectID, "Success", auditRecoveryID, new KeyId(kid), auditPublicKey));
        }
        catch (EBaseException eAudit1) {
            auditor.log((LogEvent)new SecurityDataRecoveryEvent(auditSubjectID, "Failure", auditRecoveryID, new KeyId(kid), auditPublicKey));
            throw eAudit1;
        }
        try {
            RequestQueue queue = this.engine.getRequestQueue();
            queue.processRequest(r);
            if (r.getExtDataInString("Error") == null) {
                byte[] pkcs12 = (byte[])params.get("pkcs12");
                auditAgents = this.auditAgents(creds);
                auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Success", auditRecoveryID, new KeyId(kid), null, auditAgents));
                this.destroyVolatileRequest(r.getRequestId());
                return pkcs12;
            }
            auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRecoveryID, new KeyId(kid), r.getExtDataInString("Error"), auditAgents));
            throw new EBaseException(r.getExtDataInString("Error"));
        }
        catch (EBaseException eAudit1) {
            auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRecoveryID, new KeyId(kid), eAudit1.getMessage(), auditAgents));
            throw eAudit1;
        }
    }

    public byte[] doKeyRecovery(String reqID, String password) throws EBaseException {
        Auditor auditor = this.engine.getAuditor();
        String auditSubjectID = this.auditSubjectID();
        RequestId auditRecoveryID = new RequestId(reqID);
        String auditAgents = "<null>";
        KeyId keyID = null;
        RequestRepository requestRepository = this.engine.getRequestRepository();
        RequestQueue queue = this.engine.getRequestQueue();
        Hashtable<String, Object> params = null;
        logger.debug("KeyRecoveryAuthority: in asynchronous doKeyRecovery()");
        Request r = requestRepository.readRequest(new RequestId(reqID));
        auditAgents = r.getExtDataInString("approvingAgents");
        BigInteger serialNumber = r.getExtDataInBigInteger("serialNumber");
        keyID = serialNumber != null ? new KeyId(serialNumber) : null;
        params = this.createVolatileRequest(r.getRequestId());
        params.put("transportPwd", password);
        try {
            logger.debug("KeyRecoveryAuthority: in asynchronous doKeyRecovery(), request state =" + r.getRequestStatus().toString());
            r.setRequestStatus(RequestStatus.BEGIN);
            queue.processRequest(r);
            if (r.getExtDataInString("Error") == null) {
                byte[] pkcs12 = (byte[])params.get("pkcs12");
                auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Success", auditRecoveryID, keyID, null, auditAgents));
                this.destroyVolatileRequest(r.getRequestId());
                return pkcs12;
            }
            auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRecoveryID, keyID, r.getExtDataInString("Error"), auditAgents));
            throw new EBaseException(r.getExtDataInString("Error"));
        }
        catch (EBaseException eAudit1) {
            auditor.log((LogEvent)new SecurityDataRecoveryProcessedEvent(auditSubjectID, "Failure", auditRecoveryID, keyID, eAudit1.getMessage(), auditAgents));
            throw eAudit1;
        }
    }

    public Request recoverKey(BigInteger kid, Credential[] creds, String password, X509CertImpl cert, String delivery) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        KeyRequestRepository requestRepository = engine.getKeyRequestRepository();
        Request r = requestRepository.createRequest("recovery");
        r.setExtData("serialNumber", kid);
        r.setExtData("transportPwd", password);
        r.setExtData("cert", cert);
        r.setExtData("delivery", delivery);
        RequestQueue queue = engine.getRequestQueue();
        queue.processRequest(r);
        return r;
    }

    public void processSynchronousRequest(Request request) throws EBaseException {
        SecurityDataProcessor processor = new SecurityDataProcessor(this);
        switch (request.getRequestType()) {
            case "securityDataEnrollment": {
                processor.archive(request);
                break;
            }
            case "securityDataRecovery": {
                processor.recover(request);
                break;
            }
            default: {
                throw new EBaseException("Unsupported synchronous request type: " + request.getRequestType());
            }
        }
    }

    public boolean isEphemeral(String realm) {
        try {
            return this.mConfig.getBoolean("ephemeralRequests", false);
        }
        catch (EBaseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isRetrievalSynchronous(String realm) {
        try {
            return this.getNoOfRequiredSecurityDataRecoveryAgents() == 1;
        }
        catch (EBaseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public Request recoverKey(Credential[] creds, CertificateChain encryptionChain, X509CertImpl signingCert, X509CertImpl transportCert, X500Name ownerName) throws EBaseException {
        KRAEngine engine = KRAEngine.getInstance();
        KeyRequestRepository requestRepository = engine.getKeyRequestRepository();
        Request r = requestRepository.createRequest("recovery");
        ByteArrayOutputStream certChainOut = new ByteArrayOutputStream();
        try {
            encryptionChain.encode((OutputStream)certChainOut);
            r.setExtData("encryptionCerts", certChainOut.toByteArray());
        }
        catch (IOException e) {
            logger.warn("Error encoding certificate chain", (Throwable)e);
        }
        r.setExtData("signingCert", signingCert);
        r.setExtData("transportCert", transportCert);
        DerOutputStream ownerNameOut = new DerOutputStream();
        try {
            ownerName.encode(ownerNameOut);
            r.setExtData("ownerName", ownerNameOut.toByteArray());
        }
        catch (IOException e) {
            logger.warn("Error encoding X500Name for owner name", (Throwable)e);
        }
        RequestQueue queue = engine.getRequestQueue();
        queue.processRequest(r);
        return r;
    }

    public IStorageKeyUnit getStorageKeyUnit() {
        return this.mStorageKeyUnit;
    }

    public TransportKeyUnit getTransportKeyUnit() {
        return this.mTransportKeyUnit;
    }

    public X500Name getX500Name() {
        return this.mName;
    }

    public String getNickname() {
        try {
            return this.mTransportKeyUnit.getNickName();
        }
        catch (EBaseException e) {
            return null;
        }
    }

    public void setNickname(String str) {
        try {
            this.mTransportKeyUnit.setNickName(str);
        }
        catch (EBaseException eBaseException) {
            // empty catch block
        }
    }

    public String getNewNickName() throws EBaseException {
        return this.mConfig.getString(PROP_NEW_NICKNAME, "");
    }

    public void setNewNickName(String name) {
        this.mConfig.putString(PROP_NEW_NICKNAME, name);
    }

    public IPolicy getPolicy() {
        return this.mPolicy;
    }

    public KeyRepository getKeyRepository() {
        return this.mKeyDB;
    }

    public ReplicaIDRepository getReplicaRepository() {
        return this.mReplicaRepot;
    }

    protected String getDN() {
        return this.getX500Name().toString();
    }

    private void initNotificationListeners() {
        ConfigStore nc = null;
        try {
            nc = this.mConfig.getSubStore(PROP_NOTIFY_SUBSTORE, ConfigStore.class);
            if (nc != null && nc.size() > 0) {
                String requestInQListenerClassName = nc.getString("certificateIssuedListenerClassName", "com.netscape.cms.listeners.RequestInQListener");
                try {
                    this.mReqInQListener = (RequestListener)Class.forName(requestInQListenerClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.mReqInQListener.setCMSEngine(this.engine);
                    this.mReqInQListener.init((Subsystem)this, nc);
                }
                catch (Exception e1) {
                    logger.warn(CMS.getLogMessage((String)"CMSCORE_KRA_REGISTER_LISTENER", (Object[])new Object[]{requestInQListenerClassName}), (Throwable)e1);
                }
            } else {
                logger.warn("No KRA notification Module configuration found");
            }
        }
        catch (EPropertyNotFound e) {
            logger.warn(CMS.getLogMessage((String)"CMSCORE_KRA_NOTIFY_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (EListenersException e) {
            logger.warn(CMS.getLogMessage((String)"CMSCORE_KRA_NOTIFY_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CMSCORE_KRA_NOTIFY_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
    }

    public Hashtable<String, Object> createVolatileRequest(RequestId id) {
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        this.mVolatileRequests.put(id.toString(), params);
        return params;
    }

    public Hashtable<String, Object> getVolatileRequest(RequestId id) {
        return this.mVolatileRequests.get(id.toString());
    }

    public void destroyVolatileRequest(RequestId id) {
        this.mVolatileRequests.remove(id.toString());
    }

    public String getOfficialName() {
        return OFFICIAL_NAME;
    }

    private String auditSubjectID() {
        String subjectID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        subjectID = auditContext != null ? ((subjectID = (String)auditContext.get((Object)"userid")) != null ? subjectID.trim() : "$NonRoleUser$") : "$Unidentified$";
        return subjectID;
    }

    private String auditRequesterID() {
        String requesterID = null;
        SessionContext auditContext = SessionContext.getExistingContext();
        requesterID = auditContext != null ? ((requesterID = (String)auditContext.get((Object)"requesterID")) != null ? requesterID.trim() : "$Unidentified$") : "$Unidentified$";
        return requesterID;
    }

    private RequestId auditRecoveryID() {
        String recoveryID;
        SessionContext auditContext = SessionContext.getExistingContext();
        if (auditContext != null && (recoveryID = (String)auditContext.get((Object)"recoveryID")) != null) {
            return new RequestId(recoveryID.trim());
        }
        return null;
    }

    private String auditPublicKey(java.security.cert.X509Certificate cert) {
        if (cert == null) {
            return "<null>";
        }
        byte[] rawData = cert.getPublicKey().getEncoded();
        if (rawData != null) {
            String base64Data = Utils.base64encode((byte[])rawData, (boolean)true).trim();
            return base64Data.replace("\r", "").replace("\n", "");
        }
        return "<null>";
    }

    private String auditPublicKey(KeyRecord rec) {
        if (rec == null) {
            return "<null>";
        }
        byte[] rawData = null;
        try {
            rawData = rec.getPublicKeyData();
        }
        catch (EBaseException e) {
            return "<null>";
        }
        String key = null;
        if (rawData != null) {
            String base64Data = null;
            base64Data = Utils.base64encode((byte[])rawData, (boolean)true).trim();
            key = base64Data.replace("\r", "").replace("\n", "");
        }
        if (key == null) {
            return "<null>";
        }
        return (key = key.trim()).isEmpty() ? "<null>" : key;
    }

    private String auditAgents(Credential[] creds) {
        if (creds == null) {
            return null;
        }
        Object agents = "<null>";
        String uid = null;
        for (int i = 0; i < creds.length; ++i) {
            uid = creds[i].getIdentifier();
            if (uid != null) {
                uid = uid.trim();
            }
            if (uid == null || uid.equals("")) continue;
            agents = i == 0 ? uid : (String)agents + SIGNED_AUDIT_AGENT_DELIMITER + uid;
        }
        return agents;
    }

    public KeyPair generateKeyPair(String alg, int keySize, String keyCurve, PQGParams pqg, KeyPairGeneratorSpi.Usage[] usageList) throws EBaseException {
        return this.generateKeyPair(alg, keySize, keyCurve, pqg, usageList, false);
    }

    public KeyPair generateKeyPair(String alg, int keySize, String keyCurve, PQGParams pqg, KeyPairGeneratorSpi.Usage[] usageList, boolean temp) throws EBaseException {
        KeyPairAlgorithm kpAlg = null;
        kpAlg = alg.equals("RSA") ? KeyPairAlgorithm.RSA : (alg.equals("EC") ? KeyPairAlgorithm.EC : KeyPairAlgorithm.DSA);
        try {
            KeyPair kp = this.generateKeyPair(kpAlg, keySize, keyCurve, pqg, usageList, temp);
            return kp;
        }
        catch (InvalidParameterException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_KEYSIZE_PARAMS", (String[])new String[]{"" + keySize}));
        }
        catch (PQGParamGenException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_PQG_GEN_FAILED", (String[])new String[0]));
        }
        catch (NoSuchAlgorithmException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_ALG_NOT_SUPPORTED", (String[])new String[]{kpAlg.toString()}));
        }
        catch (TokenException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_TOKEN_ERROR_1", (String[])new String[]{e.toString()}));
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_ALG_NOT_SUPPORTED", (String[])new String[]{"DSA"}));
        }
    }

    public KeyPair generateKeyPair(KeyPairAlgorithm kpAlg, int keySize, String keyCurve, PQGParams pqg, KeyPairGeneratorSpi.Usage[] usageList) throws NoSuchAlgorithmException, TokenException, InvalidAlgorithmParameterException, InvalidParameterException, PQGParamGenException {
        return this.generateKeyPair(kpAlg, keySize, keyCurve, pqg, usageList, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPair generateKeyPair(KeyPairAlgorithm kpAlg, int keySize, String keyCurve, PQGParams pqg, KeyPairGeneratorSpi.Usage[] usageList, boolean temp) throws NoSuchAlgorithmException, TokenException, InvalidAlgorithmParameterException, InvalidParameterException, PQGParamGenException {
        boolean ep;
        boolean sp;
        boolean tp;
        KeyPairGenerator kpGen;
        CryptoToken token;
        block22: {
            KRAEngine engine = KRAEngine.getInstance();
            token = this.getKeygenToken();
            logger.debug("NetkeyKeygenService: key pair is to be generated on slot: " + token.getName());
            kpGen = token.getKeyPairGenerator(kpAlg);
            KRAEngineConfig config = engine.getConfig();
            ConfigStore kgConfig = config.getSubStore("kra.keygen", ConfigStore.class);
            tp = temp;
            sp = false;
            ep = false;
            if (kgConfig != null && !kgConfig.equals("")) {
                try {
                    tp = kgConfig.getBoolean("temporaryPairs", false);
                    sp = kgConfig.getBoolean("sensitivePairs", false);
                    ep = kgConfig.getBoolean("extractablePairs", false);
                    logger.debug("NetkeyKeygenService: found config store: kra.keygen");
                    if (tp || sp || ep) break block22;
                    if (kpAlg == KeyPairAlgorithm.EC) {
                        tp = true;
                        sp = false;
                        ep = true;
                        break block22;
                    }
                    tp = true;
                }
                catch (Exception e) {
                    logger.warn("NetkeyKeygenService: kgConfig.getBoolean failed: " + e.getMessage(), (Throwable)e);
                    tp = true;
                }
            } else {
                logger.debug("NetkeyKeygenService: cannot find config store: kra.keygen, assume temporaryPairs==true");
                if (kpAlg == KeyPairAlgorithm.EC) {
                    tp = true;
                    sp = false;
                    ep = true;
                } else {
                    tp = true;
                }
            }
        }
        if (kpAlg == KeyPairAlgorithm.EC) {
            KeyPair pair = null;
            try {
                pair = CryptoUtil.generateECCKeyPair((CryptoToken)token, (String)keyCurve, (boolean)tp, (int)(sp ? 1 : 0), (int)(ep ? 1 : 0), null, (KeyPairGeneratorSpi.Usage[])CryptoUtil.ECDH_USAGES_MASK);
                logger.debug("NetkeyKeygenService: after key pair generation");
            }
            catch (Exception e) {
                logger.warn("NetkeyKeygenService: key pair generation with exception: " + e.getMessage(), (Throwable)e);
            }
            return pair;
        }
        if (tp) {
            logger.debug("NetkeyKeygenService: setting temporaryPairs to true");
            kpGen.temporaryPairs(true);
        }
        if (sp) {
            logger.debug("NetkeyKeygenService: setting sensitivePairs to true");
            kpGen.sensitivePairs(true);
        }
        if (ep) {
            logger.debug("NetkeyKeygenService: setting extractablePairs to true");
            kpGen.extractablePairs(true);
        }
        if (kpAlg == KeyPairAlgorithm.DSA) {
            if (pqg == null) {
                kpGen.initialize(keySize);
            } else {
                kpGen.initialize((AlgorithmParameterSpec)pqg);
            }
        } else {
            kpGen.initialize(keySize);
        }
        if (usageList != null) {
            kpGen.setKeyPairUsages(usageList, usageList);
        }
        if (pqg == null) {
            KeyPair kp = null;
            Object object = new Object();
            synchronized (object) {
                logger.debug("NetkeyKeygenService: key pair generation begins");
                kp = kpGen.genKeyPair();
                logger.debug("NetkeyKeygenService: key pair generation done");
                this.addEntropy(true);
            }
            return kp;
        }
        KeyPair kp = null;
        return kp;
    }
}

